/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DataSetPEByExperimentOrSampleIdentifierValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSetAuthorizationExecutor
implements IDataSetAuthorizationExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    private boolean canCreate(PersonPE person) {
        if (person.isSystemUser()) {
            return true;
        }
        AuthorizationServiceUtils authorization = new AuthorizationServiceUtils(null, person);
        return authorization.doesUserHaveRole(RoleWithHierarchy.SPACE_ETL_SERVER);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_DATASET")
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void canCreate(IOperationContext context, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
        if (!(dataSet instanceof ExternalDataPE)) {
            return;
        }
        boolean isCreatorPersonAllowed = false;
        boolean isPersonAllowed = false;
        if (context.getSession().tryGetCreatorPerson() != null) {
            isCreatorPersonAllowed = this.canCreate(context.getSession().tryGetCreatorPerson());
        }
        if (context.getSession().tryGetPerson() != null) {
            isPersonAllowed = this.canCreate(context.getSession().tryGetPerson());
        }
        if (!isCreatorPersonAllowed && !isPersonAllowed) {
            throw new UserFailureException("Data set creation can be only executed by a system user or a user with at least " + RoleWithHierarchy.SPACE_ETL_SERVER + " role.");
        }
        DataSetPEByExperimentOrSampleIdentifierValidator validator = new DataSetPEByExperimentOrSampleIdentifierValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(dataSet.getRegistrator(), dataSet)) {
            throw new UnauthorizedObjectAccessException((IObjectId)new DataSetPermId(dataSet.getPermId()));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_POWER_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_DATASET")
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void canUpdate(IOperationContext context, IDataSetId id, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
        boolean isStorageConfirmed = dataSet instanceof ExternalDataPE ? ((ExternalDataPE)dataSet).isStorageConfirmation() : true;
        DataSetPEByExperimentOrSampleIdentifierValidator validator = new DataSetPEByExperimentOrSampleIdentifierValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (isStorageConfirmed && !validator.doValidation(context.getSession().tryGetPerson(), dataSet)) {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    @Override
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET, DatabaseModificationKind.ObjectKind.DELETION})
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_POWER_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="DELETE_DATASET")
    public void canDelete(IOperationContext context, IDataSetId id, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
        this.canUpdate(context, id, dataSet);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_DATASET")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="SEARCH_DATASET")
    public void canSearch(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="FREEZE_DATASET")
    public void canFreeze(IOperationContext context, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_POWER_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="ARCHIVE_DATASET")
    public void canArchive(IOperationContext context, IDataSetId id, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UNARCHIVE_DATASET")
    public void canUnarchive(IOperationContext context, IDataSetId id, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_ADMIN})
    @Capability(value="LOCK_DATASET")
    public void canLock(IOperationContext context, IDataSetId dataSetId, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_ADMIN})
    @Capability(value="UNLOCK_DATASET")
    public void canUnlock(IOperationContext context, IDataSetId dataSetId, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE dataSet) {
    }
}

