/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.delete.DataSetDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.DeletionTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDeleteDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class DeleteDataSetExecutor
extends AbstractDeleteEntityExecutor<IDeletionId, IDataSetId, DataPE, DataSetDeletionOptions>
implements IDeleteDataSetExecutor {
    @Autowired
    private IMapDataSetByIdExecutor mapDataSetByIdExecutor;
    @Autowired
    private IDataSetAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<IDataSetId, DataPE> map(IOperationContext context, List<? extends IDataSetId> entityIds, DataSetDeletionOptions deletionOptions) {
        return this.mapDataSetByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IDataSetId entityId, DataPE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, DataPE dataSet) {
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        Session session = context.getSession();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet.getExperiment(), session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)dataSet.tryGetSample(), session, timeStamp);
        this.updateModificationDateAndModifierOfRelatedDataSets(context, dataSet.getChildren());
        this.updateModificationDateAndModifierOfRelatedDataSets(context, dataSet.getParents());
        Set<DataSetRelationshipPE> relationships = dataSet.getParentRelationships();
        for (DataSetRelationshipPE relationship : RelationshipUtils.getContainerComponentRelationships(relationships)) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getParentDataSet(), session, timeStamp);
        }
    }

    private void updateModificationDateAndModifierOfRelatedDataSets(IOperationContext context, List<DataPE> dataSets) {
        if (dataSets != null) {
            Date timeStamp = this.daoFactory.getTransactionTimestamp();
            for (DataPE child : dataSets) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, context.getSession(), timeStamp);
            }
        }
    }

    @Override
    protected IDeletionId delete(IOperationContext context, Collection<DataPE> dataSets, DataSetDeletionOptions deletionOptions) {
        try {
            ITrashBO trashBO = this.businessObjectFactory.createTrashBO(context.getSession());
            trashBO.createDeletion(deletionOptions.getReason());
            trashBO.trashDataSets(this.asTechIds(dataSets));
            DeletionPE deletion = trashBO.getDeletion();
            return new DeletionTechId(deletion.getId());
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "deletion", null);
            return null;
        }
    }
}

