/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IStorageFormatId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.StorageFormatPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapStorageFormatByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IStorageFormatAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.vocabulary.IMapVocabularyTermByIdExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapStorageFormatByIdExecutor
implements IMapStorageFormatByIdExecutor {
    @Autowired
    private IMapVocabularyTermByIdExecutor mapVocabularyTermByIdExecutor;
    @Autowired
    private IStorageFormatAuthorizationExecutor authorizationExecutor;

    @Override
    public Map<IStorageFormatId, VocabularyTermPE> map(IOperationContext context, Collection<? extends IStorageFormatId> ids) {
        return this.map(context, ids, true);
    }

    @Override
    public Map<IStorageFormatId, VocabularyTermPE> map(IOperationContext context, Collection<? extends IStorageFormatId> ids, boolean checkAccess) {
        if (checkAccess) {
            this.authorizationExecutor.canGet(context);
        }
        HashMap<VocabularyTermPermId, IStorageFormatId> idsMap = new HashMap<VocabularyTermPermId, IStorageFormatId>();
        if (ids != null) {
            for (IStorageFormatId iStorageFormatId : ids) {
                VocabularyTermPermId termId = null;
                if (!(iStorageFormatId instanceof StorageFormatPermId)) {
                    throw new UserFailureException("Unsupported storageFormat: " + iStorageFormatId);
                }
                termId = new VocabularyTermPermId(((StorageFormatPermId)iStorageFormatId).getPermId(), "$STORAGE_FORMAT");
                idsMap.put(termId, iStorageFormatId);
            }
        }
        Map termMap = this.mapVocabularyTermByIdExecutor.map(context, idsMap.keySet());
        HashMap<IStorageFormatId, VocabularyTermPE> hashMap = new HashMap<IStorageFormatId, VocabularyTermPE>();
        for (Map.Entry termEntry : termMap.entrySet()) {
            IStorageFormatId formatId = (IStorageFormatId)idsMap.get(termEntry.getKey());
            hashMap.put(formatId, (VocabularyTermPE)termEntry.getValue());
        }
        return hashMap;
    }
}

