/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetContainerExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.SetDataSetToDataSetsRelationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class SetDataSetContainerExecutor
extends SetDataSetToDataSetsRelationExecutor
implements ISetDataSetContainerExecutor {
    @Override
    protected String getRelationName() {
        return "dataset-containers";
    }

    @Override
    protected Collection<? extends IDataSetId> getRelatedIds(IOperationContext context, DataSetCreation creation) {
        return creation.getContainerIds();
    }

    @Override
    protected void setRelated(IOperationContext context, DataPE component, Collection<DataPE> containers) {
        for (DataPE container : containers) {
            if (!container.isContainer()) {
                throw new UserFailureException("Data set " + container.getCode() + " is not of a container type therefore cannot be set as a container of data set " + component.getCode() + ".");
            }
            this.relationshipService.assignDataSetToContainer(context.getSession(), component, container);
        }
    }
}

