/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityExperimentRelationExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetDataSetExperimentExecutor
extends AbstractSetEntityExperimentRelationExecutor<DataSetCreation, DataPE>
implements ISetDataSetExperimentExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected String getRelationName() {
        return "dataset-experiment";
    }

    @Override
    protected IExperimentId getRelatedId(DataSetCreation creation) {
        return creation.getExperimentId();
    }

    @Override
    protected void set(IOperationContext context, DataPE entity, ExperimentPE related) {
        if (related != null) {
            Date timeStamp = this.daoFactory.getTransactionTimestamp();
            RelationshipUtils.setExperimentForDataSet(entity, related, context.getSession(), timeStamp);
        }
    }
}

