/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.LinkedDataCreation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IAddContentCopiesToLinkedDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetExternalDmsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetLinkedDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.SetRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.ContentCopyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetDataSetLinkedDataExecutor
implements ISetDataSetLinkedDataExecutor {
    @Autowired
    private ISetDataSetExternalDmsExecutor setDataSetExternalDmsExecutor;
    @Autowired
    private IAddContentCopiesToLinkedDataExecutor addContentCopiesToLinkedDataExecutor;

    @Override
    public void set(final IOperationContext context, final MapBatch<DataSetCreation, DataPE> batch) {
        new MapBatchProcessor<DataSetCreation, DataPE>(context, batch){

            @Override
            public void process(DataSetCreation creation, DataPE entity) {
                LinkedDataCreation linkedCreation = creation.getLinkedData();
                if (entity instanceof LinkDataPE) {
                    if (linkedCreation == null) {
                        throw new UserFailureException("Linked data cannot be null for a link data set.");
                    }
                    if (SetDataSetLinkedDataExecutor.this.isLegacy(batch)) {
                        SetDataSetLinkedDataExecutor.this.setLegacy(context, linkedCreation, (LinkDataPE)entity);
                    } else {
                        SetDataSetLinkedDataExecutor.this.addContentCopiesToLinkedDataExecutor.add(context, (LinkDataPE)entity, linkedCreation.getContentCopies());
                    }
                } else if (linkedCreation != null) {
                    throw new UserFailureException("Linked data cannot be set for a non-link data set.");
                }
            }

            @Override
            public IProgress createProgress(DataSetCreation creation, DataPE entity, int objectIndex, int totalObjectCount) {
                return new SetRelationProgress(entity, (ICreation)creation, "dataset-linkeddata", objectIndex, totalObjectCount);
            }
        };
        if (this.isLegacy(batch)) {
            this.setDataSetExternalDmsExecutor.set(context, batch);
        }
    }

    private boolean isLegacy(MapBatch<DataSetCreation, DataPE> batch) {
        HashSet<Boolean> modes = new HashSet<Boolean>();
        for (DataSetCreation dsc : ((Map)batch.getObjects()).keySet()) {
            if (dsc.getLinkedData() == null) continue;
            modes.add(dsc.getLinkedData().getContentCopies() == null);
        }
        switch (modes.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return (Boolean)modes.iterator().next();
            }
            case 2: {
                throw new UserFailureException("Cannot mix deprecated and non-deprecated requests");
            }
        }
        return false;
    }

    private void setLegacy(IOperationContext context, LinkedDataCreation linkedCreation, LinkDataPE dataSet) {
        ContentCopyPE copy = new ContentCopyPE();
        copy.setDataSet(dataSet);
        if (linkedCreation.getExternalCode() == null) {
            throw new UserFailureException("External code can not be null.");
        }
        copy.setExternalCode(linkedCreation.getExternalCode());
        copy.setRegistrator(context.getSession().tryGetPerson());
        HashSet<ContentCopyPE> contentCopies = new HashSet<ContentCopyPE>();
        contentCopies.add(copy);
        dataSet.setContentCopies(contentCopies);
    }
}

