/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.ILocatorTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.RelativeLocationLocatorTypePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapLocatorTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetLocatorTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityToOneRelationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.LocatorTypePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetDataSetLocatorTypeExecutor
extends AbstractSetEntityToOneRelationExecutor<DataSetCreation, DataPE, ILocatorTypeId, LocatorTypePE>
implements ISetDataSetLocatorTypeExecutor {
    @Autowired
    private IMapLocatorTypeByIdExecutor mapLocatorTypeByIdExecutor;

    @Override
    protected String getRelationName() {
        return "dataset-locatortype";
    }

    @Override
    protected ILocatorTypeId getRelatedId(DataSetCreation creation) {
        if (creation.getPhysicalData() != null) {
            return creation.getPhysicalData().getLocatorTypeId() != null ? creation.getPhysicalData().getLocatorTypeId() : new RelativeLocationLocatorTypePermId();
        }
        return null;
    }

    @Override
    protected Map<ILocatorTypeId, LocatorTypePE> map(IOperationContext context, List<ILocatorTypeId> relatedIds) {
        return this.mapLocatorTypeByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, DataPE entity, ILocatorTypeId relatedId, LocatorTypePE related) {
        if (entity instanceof ExternalDataPE && relatedId == null) {
            throw new UserFailureException("Locator type id cannot be null for a physical data set.");
        }
    }

    @Override
    protected void set(IOperationContext context, DataPE entity, LocatorTypePE related) {
        if (entity instanceof ExternalDataPE) {
            ((ExternalDataPE)entity).setLocatorType(related);
        }
    }
}

