/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetSampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntitySampleRelationExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetDataSetSampleExecutor
extends AbstractSetEntitySampleRelationExecutor<DataSetCreation, DataPE>
implements ISetDataSetSampleExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected String getRelationName() {
        return "dataset-sample";
    }

    @Override
    protected ISampleId getRelatedId(DataSetCreation creation) {
        return creation.getSampleId();
    }

    @Override
    protected void set(IOperationContext context, DataPE entity, SamplePE related) {
        if (related != null) {
            Session session = context.getSession();
            Date timeStamp = this.daoFactory.getTransactionTimestamp();
            RelationshipUtils.setSampleForDataSet(entity, related, session, timeStamp);
            RelationshipUtils.setExperimentForDataSet(entity, related.getExperiment(), session, timeStamp);
        }
    }
}

