/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.create.DataSetCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IStorageFormatId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapStorageFormatByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.ISetDataSetStorageFormatExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityToOneRelationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetDataSetStorageFormatExecutor
extends AbstractSetEntityToOneRelationExecutor<DataSetCreation, DataPE, IStorageFormatId, VocabularyTermPE>
implements ISetDataSetStorageFormatExecutor {
    @Autowired
    private IMapStorageFormatByIdExecutor mapStorageFormatByIdExecutor;

    @Override
    protected String getRelationName() {
        return "dataset-storageformat";
    }

    @Override
    protected IStorageFormatId getRelatedId(DataSetCreation creation) {
        return creation.getPhysicalData() != null ? creation.getPhysicalData().getStorageFormatId() : null;
    }

    @Override
    protected Map<IStorageFormatId, VocabularyTermPE> map(IOperationContext context, List<IStorageFormatId> relatedIds) {
        return this.mapStorageFormatByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, DataPE entity, IStorageFormatId relatedId, VocabularyTermPE related) {
        if (entity instanceof ExternalDataPE && relatedId == null) {
            throw new UserFailureException("Storage format id cannot be null for a physical data set.");
        }
    }

    @Override
    protected void set(IOperationContext context, DataPE entity, VocabularyTermPE related) {
        if (entity instanceof ExternalDataPE) {
            ((ExternalDataPE)entity).setStorageFormatVocabularyTerm(related);
        }
    }
}

