/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.DataSetUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetContainersExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToManyRelationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DataSetPEByExperimentOrSampleIdentifierValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateDataSetContainersExecutor
extends AbstractUpdateEntityToManyRelationExecutor<DataSetUpdate, DataPE, IDataSetId, DataPE>
implements IUpdateDataSetContainersExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected String getRelationName() {
        return "dataset-containers";
    }

    @Override
    protected Collection<DataPE> getCurrentlyRelated(DataPE entity) {
        return entity.getContainers();
    }

    @Override
    protected IdListUpdateValue<? extends IDataSetId> getRelatedUpdate(IOperationContext context, DataSetUpdate update) {
        return update.getContainerIds();
    }

    @Override
    protected void check(IOperationContext context, DataPE entity, IDataSetId relatedId, DataPE related) {
        DataSetPEByExperimentOrSampleIdentifierValidator validator = new DataSetPEByExperimentOrSampleIdentifierValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void add(IOperationContext context, DataPE entity, DataPE related) {
        if (!related.isContainer()) {
            throw new UserFailureException("Data set " + related.getCode() + " is not of a container type therefore cannot be set as a container of data set " + entity.getCode() + ".");
        }
        this.relationshipService.assignDataSetToContainer(context.getSession(), entity, related);
    }

    @Override
    protected void remove(IOperationContext context, DataPE entity, DataPE related) {
        this.relationshipService.removeDataSetFromContainer(context.getSession(), entity, related);
    }
}

