/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.DataSetUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.IEventExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetLinkedDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetPhysicalDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetRelatedDataSetsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetSampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagForEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingEvent;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingFlags;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateDataSetExecutor
extends AbstractUpdateEntityExecutor<DataSetUpdate, DataPE, IDataSetId, DataSetPermId>
implements IUpdateDataSetExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IDataSetAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapDataSetByIdExecutor mapDataSetByIdExecutor;
    @Autowired
    private IUpdateDataSetExperimentExecutor updateDataSetExperimentExecutor;
    @Autowired
    private IUpdateDataSetSampleExecutor updateDataSetSampleExecutor;
    @Autowired
    private IUpdateDataSetPhysicalDataExecutor updateDataSetPhysicalDataExecutor;
    @Autowired
    private IUpdateDataSetLinkedDataExecutor updateDataSetLinkedDataExecutor;
    @Autowired
    private IUpdateDataSetRelatedDataSetsExecutor updateDataSetRelatedDataSetsExecutor;
    @Autowired
    private IUpdateDataSetPropertyExecutor updateDataSetPropertyExecutor;
    @Autowired
    private IUpdateTagForEntityExecutor updateTagForEntityExecutor;
    @Autowired
    private IEventExecutor eventExecutor;

    @Override
    protected IDataSetId getId(DataSetUpdate update) {
        return update.getDataSetId();
    }

    @Override
    protected DataSetPermId getPermId(DataPE entity) {
        return new DataSetPermId(entity.getCode());
    }

    @Override
    protected void checkData(IOperationContext context, DataSetUpdate update) {
        if (update.getDataSetId() == null) {
            throw new UserFailureException("Data set id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IDataSetId id, DataPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<DataSetUpdate, DataPE> batch) {
        this.updateDataSetPhysicalDataExecutor.update(context, batch);
        this.updateDataSetLinkedDataExecutor.update(context, batch);
        this.updateDataSetExperimentExecutor.update(context, batch);
        this.updateDataSetSampleExecutor.update(context, batch);
        this.updateDataSetPropertyExecutor.update(context, batch);
        this.updateTags(context, batch);
        PersonPE person = context.getSession().tryGetPerson();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        ArrayList<FreezingEvent> freezingEvents = new ArrayList<FreezingEvent>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            DataSetUpdate update = (DataSetUpdate)entry.getKey();
            DataPE entity = (DataPE)entry.getValue();
            FreezingFlags freezingFlags = new FreezingFlags();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)entity, person, timeStamp);
            if (update.shouldBeFrozen()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozen(true);
                freezingFlags.freeze();
            }
            if (update.shouldBeFrozenForChildren()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForChildren(true);
                freezingFlags.freezeForChildren();
            }
            if (update.shouldBeFrozenForParents()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForParents(true);
                freezingFlags.freezeForParents();
            }
            if (update.shouldBeFrozenForComponents()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForComponents(true);
                freezingFlags.freezeForComponents();
            }
            if (update.shouldBeFrozenForContainers()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForContainers(true);
                freezingFlags.freezeForContainers();
            }
            if (freezingFlags.noFlags()) continue;
            freezingEvents.add(new FreezingEvent(entity.getIdentifier(), EventPE.EntityType.DATASET, freezingFlags));
        }
        if (!freezingEvents.isEmpty()) {
            this.eventExecutor.persist(context, freezingEvents);
        }
    }

    private void updateTags(final IOperationContext context, MapBatch<DataSetUpdate, DataPE> batch) {
        new MapBatchProcessor<DataSetUpdate, DataPE>(context, batch){

            @Override
            public void process(DataSetUpdate update, DataPE entity) {
                if (update.getTagIds() != null && update.getTagIds().hasActions()) {
                    UpdateDataSetExecutor.this.updateTagForEntityExecutor.update(context, entity, (IdListUpdateValue<ITagId>)update.getTagIds());
                }
            }

            @Override
            public IProgress createProgress(DataSetUpdate key, DataPE value, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)key, value, "dataset-tag", objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<DataSetUpdate, DataPE> batch) {
        this.updateDataSetRelatedDataSetsExecutor.update(context, batch);
    }

    @Override
    protected Map<IDataSetId, DataPE> map(IOperationContext context, Collection<IDataSetId> ids) {
        return this.mapDataSetByIdExecutor.map(context, ids);
    }

    @Override
    protected List<DataPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getDataDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<DataPE> entities, boolean clearCache) {
        this.daoFactory.getDataDAO().updateDataSets(entities, context.getSession().tryGetPerson());
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, EntityKind.DATA_SET.getLabel(), EntityKind.DATA_SET);
    }
}

