/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.ContentCopyPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IContentCopyId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.DataSetUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.update.LinkedDataUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IAddContentCopiesToLinkedDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetExternalDmsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IUpdateDataSetLinkedDataExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.ContentCopyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateDataSetLinkedDataExecutor
implements IUpdateDataSetLinkedDataExecutor {
    @Autowired
    private IUpdateDataSetExternalDmsExecutor updateDataSetExternalDmsExecutor;
    @Autowired
    private IAddContentCopiesToLinkedDataExecutor addContentCopiesToLinkedDataExecutor;
    @Autowired
    protected IDAOFactory daoFactory;

    @Override
    public void update(IOperationContext context, MapBatch<DataSetUpdate, DataPE> batch) {
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            DataSetUpdate update = (DataSetUpdate)entry.getKey();
            DataPE entity = (DataPE)entry.getValue();
            if (!(entity instanceof LinkDataPE) || update.getLinkedData() == null || !update.getLinkedData().isModified()) continue;
            this.update(context, (LinkedDataUpdate)update.getLinkedData().getValue(), (LinkDataPE)entity);
        }
        this.updateDataSetExternalDmsExecutor.update(context, batch);
    }

    private void update(IOperationContext context, LinkedDataUpdate update, LinkDataPE entity) {
        Collection set;
        if (update.getExternalCode() != null && update.getExternalCode().isModified()) {
            Set<ContentCopyPE> contentCopies = entity.getContentCopies();
            if (contentCopies.size() == 1) {
                ContentCopyPE current = contentCopies.iterator().next();
                ContentCopyPE newCopy = new ContentCopyPE();
                newCopy.setExternalCode(current.getExternalCode());
                newCopy.setDataSet(current.getDataSet());
                newCopy.setExternalDataManagementSystem(current.getExternalDataManagementSystem());
                newCopy.setRegistrator(context.getSession().tryGetPerson());
                newCopy.setLocationType(current.getLocationType());
                if (current.getExternalCode() == null) {
                    throw new UserFailureException("Cannot set external code to content copy of type" + (Object)((Object)current.getLocationType()));
                }
                newCopy.setExternalCode((String)update.getExternalCode().getValue());
                contentCopies.remove(current);
                this.daoFactory.getSessionFactory().getCurrentSession().flush();
                contentCopies.add(newCopy);
            } else {
                throw new UserFailureException("Cannot set external code to linked dataset with multiple or zero copies");
            }
        }
        if (!(set = update.getContentCopies().getSet()).isEmpty()) {
            for (ContentCopyPE cc : entity.getContentCopies()) {
                this.daoFactory.getSessionFactory().getCurrentSession().delete((Object)cc);
            }
            entity.getContentCopies().removeAll(entity.getContentCopies());
            this.daoFactory.getSessionFactory().getCurrentSession().flush();
            this.addContentCopiesToLinkedDataExecutor.add(context, entity, set);
        } else {
            Collection removed = update.getContentCopies().getRemoved();
            HashSet<ContentCopyPE> remove = new HashSet<ContentCopyPE>();
            for (ContentCopyPE cc : entity.getContentCopies()) {
                if (cc.getId() == null || !removed.contains(new ContentCopyPermId(cc.getId().toString()))) continue;
                remove.add(cc);
            }
            this.assertAllRemovalsExists(entity, update);
            entity.getContentCopies().removeAll(remove);
            for (ContentCopyPE cc : remove) {
                this.daoFactory.getSessionFactory().getCurrentSession().delete((Object)cc);
            }
            this.daoFactory.getSessionFactory().getCurrentSession().flush();
            this.addContentCopiesToLinkedDataExecutor.add(context, entity, update.getContentCopies().getAdded());
        }
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        PersonPE person = context.getSession().tryGetPerson();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)entity, person, timeStamp);
    }

    private void assertAllRemovalsExists(LinkDataPE entity, LinkedDataUpdate update) {
        block0: for (IContentCopyId iid : update.getContentCopies().getRemoved()) {
            ContentCopyPermId id = (ContentCopyPermId)iid;
            for (ContentCopyPE cc : entity.getContentCopies()) {
                if (!id.getPermId().equals(cc.getId().toString())) continue;
                continue block0;
            }
            throw new UserFailureException("Trying to remove non-existing content copy " + id.getPermId());
        }
    }
}

