/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetContentCopyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.systemsx.cisd.openbis.generic.shared.dto.ContentCopyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class VerifyDataSetContentCopyExecutor
implements IVerifyDataSetContentCopyExecutor {
    @Override
    public void verify(IOperationContext context, CollectionBatch<? extends DataPE> batch) {
        new CollectionBatchProcessor<DataPE>(context, batch){

            @Override
            public void process(DataPE dataSet) {
                VerifyDataSetContentCopyExecutor.this.verify(dataSet);
            }

            @Override
            public IProgress createProgress(DataPE object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }

    protected void verify(DataPE dataSet) {
        LinkDataPE linkDataPE;
        Map<String, List<ContentCopyPE>> byRepositoryId;
        if (dataSet instanceof LinkDataPE && (byRepositoryId = (linkDataPE = (LinkDataPE)dataSet).getContentCopies().stream().filter(cc -> cc.getGitRepositoryId() != null).collect(Collectors.groupingBy(cc -> cc.getGitRepositoryId()))).keySet().size() > 1) {
            throw new IllegalArgumentException("Within one data set, all git repository ids must be the same.");
        }
    }
}

