/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.IDataSetId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IMapDataSetByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetContainersExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetContentCopyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetParentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetSampleAndExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IVerifyEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifyDataSetExecutor
implements IVerifyDataSetExecutor {
    @Autowired
    private IMapDataSetByIdExecutor mapDataSetByIdExecutor;
    @Autowired
    private IVerifyDataSetSampleAndExperimentExecutor verifyDataSetSampleAndExperimentExecutor;
    @Autowired
    private IVerifyEntityPropertyExecutor verifyEntityPropertyExecutor;
    @Autowired
    private IVerifyDataSetContainersExecutor verifyDataSetContainersExecutor;
    @Autowired
    private IVerifyDataSetParentsExecutor verifyDataSetParentsExecutor;
    @Autowired
    private IVerifyDataSetContentCopyExecutor verifyDataSetContentCopyExecutor;

    @Override
    public void verify(IOperationContext context, CollectionBatch<? extends IDataSetId> dataSetIds) {
        if (dataSetIds != null && !dataSetIds.isEmpty()) {
            Map map = this.mapDataSetByIdExecutor.map(context, (Collection)dataSetIds.getObjects());
            CollectionBatch dataSets = new CollectionBatch(dataSetIds.getBatchIndex(), dataSetIds.getFromObjectIndex(), dataSetIds.getToObjectIndex(), map.values(), dataSetIds.getTotalObjectCount());
            this.verifyDataSetSampleAndExperimentExecutor.verify(context, dataSets);
            this.verifyEntityPropertyExecutor.verify(context, dataSets);
            this.verifyDataSetContainersExecutor.verify(context, dataSets);
            this.verifyDataSetParentsExecutor.verify(context, dataSets);
            this.verifyDataSetContentCopyExecutor.verify(context, dataSets);
        }
    }
}

