/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IVerifyDataSetSampleAndExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.utils.EntityUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class VerifyDataSetSampleAndExperimentExecutor
implements IVerifyDataSetSampleAndExperimentExecutor {
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    private DataSetTypeWithoutExperimentChecker dataSetTypeChecker;

    @PostConstruct
    public void init() throws Exception {
        this.dataSetTypeChecker = new DataSetTypeWithoutExperimentChecker(this.configurer == null ? new Properties() : this.configurer.getResolvedProps());
    }

    @Override
    public void verify(final IOperationContext context, CollectionBatch<DataPE> batch) {
        new CollectionBatchProcessor<DataPE>(context, batch){

            @Override
            public void process(DataPE dataSet) {
                VerifyDataSetSampleAndExperimentExecutor.this.verify(context, dataSet);
            }

            @Override
            public IProgress createProgress(DataPE object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }

    private void verify(IOperationContext context, DataPE dataSet) {
        ExperimentPE experiment = dataSet.getExperiment();
        SamplePE sample = dataSet.tryGetSample();
        this.verifyExperimentNotInTrash(experiment);
        this.verifySampleNotInTrash(sample);
        if (sample == null && experiment == null) {
            throw new UserFailureException("Data set cannot be registered because it is neither connected to a sample nor to an experiment.");
        }
        if (sample == null && experiment != null) {
            return;
        }
        if (sample != null && experiment == null) {
            this.verifySampleNotShared(sample);
            this.verifyExperimentNotNeeded(dataSet);
        } else if (sample != null && experiment != null) {
            this.verifySampleNotShared(sample);
            this.verifySampleInExperiment(sample, experiment);
        }
    }

    private void verifyExperimentNotInTrash(ExperimentPE experiment) {
        if (experiment != null && experiment.getDeletion() != null) {
            throw new UserFailureException("Data set can not be registered because experiment '" + EntityUtils.render(experiment) + "' is in trash.");
        }
    }

    private void verifyExperimentNotNeeded(DataPE dataSet) {
        if (!this.dataSetTypeChecker.isDataSetTypeWithoutExperiment(dataSet.getDataSetType().getCode())) {
            throw new UserFailureException("Data set can not be registered because it is not connected to an experiment.");
        }
    }

    private void verifySampleNotInTrash(SamplePE sample) {
        if (sample != null && sample.getDeletion() != null) {
            throw new UserFailureException("Data set can not be registered because sample '" + sample.getSampleIdentifier() + "' is in trash.");
        }
    }

    private void verifySampleNotShared(SamplePE sample) {
        if (sample.getSpace() == null) {
            throw new UserFailureException("Data set can not be registered because sample '" + sample.getSampleIdentifier() + "' is a shared sample.");
        }
    }

    private void verifySampleInExperiment(SamplePE sample, ExperimentPE experiment) {
        if (!experiment.equals(sample.getExperiment())) {
            throw new UserFailureException("Data set can not be registered because it connected to a different experiment than its sample.");
        }
    }
}

