/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.datastore;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.search.DataStoreSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.datastore.IDataStoreAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.datastore.ISearchDataStoreExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchDataStoreExecutor
extends AbstractSearchObjectManuallyExecutor<DataStoreSearchCriteria, DataStorePE>
implements ISearchDataStoreExecutor {
    @Autowired
    private IDataStoreAuthorizationExecutor authorizationExecutor;

    @Override
    public List<DataStorePE> search(IOperationContext context, DataStoreSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<DataStorePE> listAll() {
        return this.daoFactory.getDataStoreDAO().listDataStores();
    }

    @Override
    protected Matcher<DataStorePE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof PermIdSearchCriteria || criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<DataStorePE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<DataStorePE>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class IdMatcher
    extends SimpleFieldMatcher<DataStorePE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, DataStorePE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof DataStorePermId) {
                return object.getCode().equals(((DataStorePermId)id).getPermId());
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

