/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.DeletionTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IConfirmDeletionExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IDeletionAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IMapDeletionByIdExecutor;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DeletionValidator;
import ch.systemsx.cisd.openbis.generic.server.business.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletedDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletionTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class ConfirmDeletionExecutor
implements IConfirmDeletionExecutor {
    private static final Comparator<IDeletionId> DELETION_ID_COMPARATOR = new Comparator<IDeletionId>(){

        @Override
        public int compare(IDeletionId o1, IDeletionId o2) {
            long id2;
            long id1 = ((DeletionTechId)o1).getTechId();
            return id1 < (id2 = ((DeletionTechId)o2).getTechId().longValue()) ? -1 : (id1 > id2 ? 1 : 0);
        }
    };
    @Autowired
    private IMapDeletionByIdExecutor mapDeletionByIdExecutor;
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IDeletionAuthorizationExecutor authorizationExecutor;
    @Resource(name="common-business-object-factory")
    ICommonBusinessObjectFactory businessObjectFactory;

    @Override
    public void confirm(IOperationContext context, List<? extends IDeletionId> deletionIds, boolean forceDeletion, boolean forceDeletionOfDependentDeletions) {
        if (context == null) {
            throw new UserFailureException("Context cannot be null.");
        }
        if (deletionIds == null) {
            throw new UserFailureException("Deletion ids cannot be null.");
        }
        ArrayList<IDeletionId> deletionIdsWithoutNulls = new ArrayList<IDeletionId>();
        for (IDeletionId iDeletionId : deletionIds) {
            if (iDeletionId == null) continue;
            deletionIdsWithoutNulls.add(iDeletionId);
        }
        try {
            if (forceDeletion) {
                this.authorizationExecutor.canConfirmForced(context, deletionIdsWithoutNulls);
            } else {
                this.authorizationExecutor.canConfirm(context, deletionIdsWithoutNulls);
            }
        }
        catch (AuthorizationFailureException ex) {
            throw new UnauthorizedObjectAccessException(deletionIdsWithoutNulls);
        }
        List<TechId> dependentDeletions = this.getDependentDelitions(deletionIdsWithoutNulls);
        if (!dependentDeletions.isEmpty()) {
            if (forceDeletionOfDependentDeletions) {
                deletionIdsWithoutNulls.addAll(TechId.asLongs(dependentDeletions).stream().map(DeletionTechId::new).collect(Collectors.toList()));
            } else {
                throw DeletionUtils.createException(context.getSession(), this.businessObjectFactory, TechId.asLongs(dependentDeletions));
            }
        }
        Collections.sort(deletionIdsWithoutNulls, DELETION_ID_COMPARATOR);
        IDeletionDAO iDeletionDAO = this.daoFactory.getDeletionDAO();
        Map deletionMap = this.mapDeletionByIdExecutor.map(context, deletionIdsWithoutNulls);
        LinkedList<Long> deletionTechIds = new LinkedList<Long>();
        for (DeletionPE deletion : deletionMap.values()) {
            deletionTechIds.add(deletion.getId());
        }
        IDeletionTable table = this.businessObjectFactory.createDeletionTable(context.getSession());
        table.load(deletionTechIds, true);
        List<Deletion> deletions = table.getDeletions();
        DeletionValidator validator = new DeletionValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        for (Deletion deletion : deletions) {
            if (validator.doValidation(context.getSession().tryGetPerson(), deletion)) continue;
            throw new UnauthorizedObjectAccessException((IObjectId)new DeletionTechId(deletion.getId()));
        }
        for (IDeletionId deletionId : deletionIdsWithoutNulls) {
            DeletionPE deletion = (DeletionPE)deletionMap.get(deletionId);
            if (deletion == null) {
                throw new ObjectNotFoundException((IObjectId)deletionId);
            }
            this.deleteDataSets(context, deletion, forceDeletion);
            this.deleteSamples(context, deletion);
            this.deleteExperiments(context, deletion);
            DeletionPE freshDeletion = (DeletionPE)iDeletionDAO.getByTechId(TechId.create((IIdHolder)deletion));
            iDeletionDAO.delete(freshDeletion);
        }
    }

    private List<TechId> getDependentDelitions(List<? extends IDeletionId> deletionIds) {
        ArrayList<TechId> techIds = new ArrayList<TechId>();
        for (IDeletionId iDeletionId : deletionIds) {
            if (iDeletionId instanceof DeletionTechId) {
                techIds.add(new TechId(((DeletionTechId)iDeletionId).getTechId()));
                continue;
            }
            throw new UserFailureException("Unsupported type of deletion id: " + iDeletionId.getClass());
        }
        return this.daoFactory.getDeletionDAO().listAllDependentDeletions(techIds);
    }

    private void deleteDataSets(IOperationContext context, DeletionPE deletion, boolean forceDeletion) {
        try {
            IDeletionDAO deletionDAO = this.daoFactory.getDeletionDAO();
            List<TechId> deletionTechIds = Collections.singletonList(new TechId(deletion.getId()));
            List<String> dataSetCodes = deletionDAO.findTrashedDataSetCodes(deletionTechIds);
            IDeletedDataSetTable deletedDataSetTable = this.businessObjectFactory.createDeletedDataSetTable(context.getSession());
            deletedDataSetTable.loadByDataSetCodes(dataSetCodes);
            deletedDataSetTable.permanentlyDeleteLoadedDataSets(deletion.getReason(), forceDeletion);
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "data set", EntityKind.DATA_SET);
            return;
        }
    }

    private void deleteSamples(IOperationContext context, DeletionPE deletion) {
        try {
            ISampleDAO sampleDAO = this.daoFactory.getSampleDAO();
            sampleDAO.deletePermanently(deletion, context.getSession().tryGetPerson());
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "sample", EntityKind.SAMPLE);
            return;
        }
    }

    private void deleteExperiments(IOperationContext context, DeletionPE deletion) {
        try {
            IDeletionDAO deletionDAO = this.daoFactory.getDeletionDAO();
            IExperimentBO experimentBO = this.businessObjectFactory.createExperimentBO(context.getSession());
            List<TechId> deletionTechIds = Collections.singletonList(new TechId(deletion.getId()));
            List<TechId> experimentTechIds = deletionDAO.findTrashedExperimentIds(deletionTechIds);
            experimentBO.deleteByTechIds(experimentTechIds, deletion.getReason());
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "experiment", EntityKind.EXPERIMENT);
            return;
        }
    }
}

