/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.DeletionTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IDeletionAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IMapDeletionByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IRevertDeletionExecutor;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DeletionValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletionTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RevertDeletionExecutor
implements IRevertDeletionExecutor {
    @Autowired
    private IMapDeletionByIdExecutor mapDeletionByIdExecutor;
    @Autowired
    private IDAOFactory daoFactory;
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IDeletionAuthorizationExecutor authorizationExecutor;

    @Override
    public void revert(IOperationContext context, List<? extends IDeletionId> deletionIds) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (deletionIds == null) {
            throw new IllegalArgumentException("Deletion ids cannot be null");
        }
        ITrashBO trashBO = this.businessObjectFactory.createTrashBO(context.getSession());
        HashSet<TechId> deletedExperimentIds = new HashSet<TechId>();
        HashSet<TechId> deletedSampleIds = new HashSet<TechId>();
        HashSet<String> deletedDataSetCodes = new HashSet<String>();
        for (Deletion deletion : this.getDeletions(context, deletionIds)) {
            List<IEntityInformationHolderWithIdentifier> deletedEntities = deletion.getDeletedEntities();
            for (IEntityInformationHolderWithIdentifier deletedEntity : deletedEntities) {
                EntityKind entityKind = deletedEntity.getEntityKind();
                TechId entityId = new TechId(deletedEntity.getId());
                switch (entityKind) {
                    case EXPERIMENT: {
                        deletedExperimentIds.add(entityId);
                        break;
                    }
                    case SAMPLE: {
                        deletedSampleIds.add(entityId);
                        break;
                    }
                    case DATA_SET: {
                        deletedDataSetCodes.add(deletedEntity.getCode());
                        break;
                    }
                }
            }
            trashBO.revertDeletion(new TechId(deletion.getId()));
        }
        this.updateModificationDateAndModifierOfRelatedProjectsOfExperiments(context, deletedExperimentIds);
        this.updateModificationDateAndModifierOfRelatedEntitiesOfSamples(context, deletedSampleIds);
        this.updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(context, deletedDataSetCodes);
    }

    private List<Deletion> getDeletions(IOperationContext context, List<? extends IDeletionId> deletionIds) {
        Map map = this.mapDeletionByIdExecutor.map(context, deletionIds);
        LinkedList<Long> deletionTechIds = new LinkedList<Long>();
        try {
            this.authorizationExecutor.canRevert(context, deletionIds);
        }
        catch (AuthorizationFailureException ex) {
            throw new UnauthorizedObjectAccessException(deletionIds);
        }
        for (IDeletionId iDeletionId : deletionIds) {
            DeletionPE deletion = (DeletionPE)map.get(iDeletionId);
            if (deletion == null) {
                throw new ObjectNotFoundException((IObjectId)iDeletionId);
            }
            deletionTechIds.add(deletion.getId());
        }
        IDeletionTable table = this.businessObjectFactory.createDeletionTable(context.getSession());
        table.load(deletionTechIds, true);
        List<Deletion> list = table.getDeletions();
        DeletionValidator validator = new DeletionValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        for (Deletion deletion : list) {
            if (validator.doValidation(context.getSession().tryGetPerson(), deletion)) continue;
            throw new UnauthorizedObjectAccessException((IObjectId)new DeletionTechId(deletion.getId()));
        }
        return list;
    }

    private void updateModificationDateAndModifierOfRelatedProjectsOfExperiments(IOperationContext context, Collection<TechId> experimentIds) {
        List<ExperimentPE> experiments = this.daoFactory.getExperimentDAO().listByIDs(TechId.asLongs(experimentIds));
        Session session = context.getSession();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        for (ExperimentPE experiment : experiments) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment.getProject(), session, timeStamp);
        }
    }

    private void updateModificationDateAndModifierOfRelatedEntitiesOfSamples(IOperationContext context, Collection<TechId> sampleIds) {
        List<SamplePE> samples = this.daoFactory.getSampleDAO().listByIDs(TechId.asLongs(sampleIds));
        Session session = context.getSession();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        for (SamplePE sample : samples) {
            Set<SampleRelationshipPE> childRelationships;
            List<SamplePE> parents;
            SamplePE container;
            ExperimentPE experiment = sample.getExperiment();
            if (experiment != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, timeStamp);
            }
            if ((container = sample.getContainer()) != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session, timeStamp);
            }
            if ((parents = sample.getParents()) != null) {
                for (SamplePE parent : parents) {
                    RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, timeStamp);
                }
            }
            if ((childRelationships = sample.getChildRelationships()) == null) continue;
            for (SampleRelationshipPE childRelationship : childRelationships) {
                SamplePE childSample = childRelationship.getChildSample();
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)childSample, session, timeStamp);
            }
        }
    }

    private void updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(IOperationContext context, Collection<String> dataSetCodes) {
        List<DataPE> dataSets = this.daoFactory.getDataDAO().listByCode(new HashSet<String>(dataSetCodes));
        Session session = context.getSession();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        for (DataPE dataSet : dataSets) {
            ExperimentPE experiment = dataSet.getExperiment();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, timeStamp);
            SamplePE sample = dataSet.tryGetSample();
            if (sample != null) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
            }
            this.updateModificationDateAndModifierOfDataSets(context, dataSet.getChildren());
            this.updateModificationDateAndModifierOfDataSets(context, dataSet.getParents());
            Set<DataSetRelationshipPE> relationships = dataSet.getParentRelationships();
            for (DataSetRelationshipPE relationship : RelationshipUtils.getContainerComponentRelationships(relationships)) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getParentDataSet(), session, timeStamp);
            }
        }
    }

    private void updateModificationDateAndModifierOfDataSets(IOperationContext context, List<DataPE> dataSets) {
        if (dataSets != null) {
            Session session = context.getSession();
            Date timeStamp = this.daoFactory.getTransactionTimestamp();
            for (DataPE child : dataSets) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, session, timeStamp);
            }
        }
    }
}

