/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.fetchoptions.DeletionFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.DeletionTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.search.DeletionSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.IDeletionAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.deletion.ISearchDeletionExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletionTable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchDeletionExecutor
implements ISearchDeletionExecutor {
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IDeletionAuthorizationExecutor authorizationExecutor;

    @Override
    public List<Deletion> search(IOperationContext context, DeletionSearchCriteria criteria, DeletionFetchOptions fetchOptions) {
        this.authorizationExecutor.canSearch(context);
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (fetchOptions == null) {
            throw new IllegalArgumentException("Fetch options cannot be null");
        }
        List<Deletion> deletions = null;
        deletions = fetchOptions.hasDeletedObjects() ? this.listWithDeletedObjects(context) : this.listWithoutDeletedObjects(context);
        if (criteria.getCriteria() != null && !criteria.getCriteria().isEmpty()) {
            deletions = new SearchDeletions(deletions).search(context, criteria);
        }
        if (deletions == null) {
            return Collections.emptyList();
        }
        Collections.sort(deletions, new Comparator<Deletion>(){

            @Override
            public int compare(Deletion d1, Deletion d2) {
                return d1.getRegistrationDate().compareTo(d2.getRegistrationDate());
            }
        });
        return deletions;
    }

    private List<Deletion> listWithDeletedObjects(IOperationContext context) {
        IDeletionTable deletionTable = this.businessObjectFactory.createDeletionTable(context.getSession());
        deletionTable.load(true);
        return deletionTable.getDeletions();
    }

    private List<Deletion> listWithoutDeletedObjects(IOperationContext context) {
        IDeletionTable deletionTable = this.businessObjectFactory.createDeletionTable(context.getSession());
        deletionTable.load(false);
        return deletionTable.getDeletions();
    }

    private class SearchDeletions
    extends AbstractSearchObjectManuallyExecutor<DeletionSearchCriteria, Deletion> {
        private List<Deletion> allDeletions;

        public SearchDeletions(List<Deletion> allDeletions) {
            this.allDeletions = allDeletions;
        }

        @Override
        protected List<Deletion> listAll() {
            return this.allDeletions;
        }

        @Override
        protected Matcher<Deletion> getMatcher(ISearchCriteria criteria) {
            if (criteria instanceof IdSearchCriteria) {
                return new IdMatcher();
            }
            throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
        }

        private class IdMatcher
        extends SimpleFieldMatcher<Deletion> {
            private IdMatcher() {
            }

            @Override
            protected boolean isMatching(IOperationContext context, Deletion object, ISearchCriteria criteria) {
                IObjectId id = ((IdSearchCriteria)criteria).getId();
                if (id == null) {
                    return true;
                }
                if (id instanceof DeletionTechId) {
                    DeletionTechId techId = (DeletionTechId)id;
                    return object.getId().equals(techId.getTechId());
                }
                throw new IllegalArgumentException("Unknown id: " + id.getClass());
            }
        }
    }
}

