/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICreationIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ICreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.CreationIdCache;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.Batch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CheckAccessProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CheckDataProgress;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;

public abstract class AbstractCreateEntityExecutor<CREATION extends ICreation, PE extends IIdHolder, PERM_ID extends IObjectId>
implements ICreateEntityExecutor<CREATION, PERM_ID> {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public List<PERM_ID> create(IOperationContext context, List<CREATION> creations) {
        this.checkAccess(context);
        if (creations == null || creations.isEmpty()) {
            return new ArrayList();
        }
        try {
            LinkedList permIdsAll = new LinkedList();
            LinkedHashMap entitiesAll = new LinkedHashMap();
            for (CollectionBatch<CREATION> batch : Batch.createBatches(creations)) {
                this.createEntities(context, batch, permIdsAll, entitiesAll);
            }
            this.daoFactory.getSessionFactory().getCurrentSession().flush();
            this.reloadEntities(context, entitiesAll);
            this.updateAll(context, new MapBatch(0, 0, entitiesAll.size(), entitiesAll, entitiesAll.size()));
            this.daoFactory.getSessionFactory().getCurrentSession().flush();
            this.reloadEntities(context, entitiesAll);
            return permIdsAll;
        }
        catch (DataAccessException e) {
            this.handleException(e);
            return null;
        }
        catch (PersistenceException e) {
            Throwable endOfChain = ExceptionUtils.getEndOfChain((Throwable)e);
            throw new UserFailureException(endOfChain.getMessage(), endOfChain);
        }
    }

    private void checkData(final IOperationContext context, CollectionBatch<CREATION> batch) {
        new CollectionBatchProcessor<CREATION>(context, batch){

            @Override
            public void process(CREATION object) {
                AbstractCreateEntityExecutor.this.checkData(context, object);
            }

            @Override
            public IProgress createProgress(CREATION object, int objectIndex, int totalObjectCount) {
                return new CheckDataProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
    }

    private void checkAccess(final IOperationContext context, MapBatch<CREATION, PE> batch) {
        new MapBatchProcessor<CREATION, PE>(context, batch){

            @Override
            public void process(CREATION creation, PE entity) {
                try {
                    AbstractCreateEntityExecutor.this.checkAccess(context, entity);
                }
                catch (AuthorizationFailureException ex) {
                    throw new UnauthorizedObjectAccessException(AbstractCreateEntityExecutor.this.getId(entity));
                }
            }

            @Override
            public IProgress createProgress(CREATION creation, PE entity, int objectIndex, int totalObjectCount) {
                return new CheckAccessProgress((IIdHolder)entity, (ICreation)creation, objectIndex, totalObjectCount);
            }
        };
    }

    private void createEntities(IOperationContext context, CollectionBatch<CREATION> batch, List<PERM_ID> permIdsAll, Map<CREATION, PE> entitiesAll) {
        LinkedHashMap<ICreation, IIdHolder> creationToEntityMap = new LinkedHashMap<ICreation, IIdHolder>();
        this.daoFactory.setBatchUpdateMode(true);
        this.checkData(context, (CREATION)batch);
        List<PE> entities = this.createEntities(context, batch);
        Iterator iterCreations = ((Collection)batch.getObjects()).iterator();
        Iterator<PE> iterEntities = entities.iterator();
        while (iterCreations.hasNext() && iterEntities.hasNext()) {
            ICreation creation = (ICreation)iterCreations.next();
            IIdHolder entity = (IIdHolder)iterEntities.next();
            entitiesAll.put(creation, entity);
            creationToEntityMap.put(creation, entity);
        }
        MapBatch mapBatch = new MapBatch(batch.getBatchIndex(), batch.getFromObjectIndex(), batch.getToObjectIndex(), creationToEntityMap, batch.getTotalObjectCount());
        this.updateBatch(context, mapBatch);
        this.checkAccess(context, (PE)mapBatch);
        this.save(context, new ArrayList(creationToEntityMap.values()), false);
        CreationIdCache creationIdCache = CreationIdCache.getInstance(context);
        for (Map.Entry entry : creationToEntityMap.entrySet()) {
            ICreationIdHolder creationIdHolder;
            ICreation creation = (ICreation)entry.getKey();
            IIdHolder entity = (IIdHolder)entry.getValue();
            PERM_ID permId = this.createPermId(context, entity);
            permIdsAll.add(permId);
            if (!(creation instanceof ICreationIdHolder) || (creationIdHolder = (ICreationIdHolder)creation).getCreationId() == null) continue;
            creationIdCache.putIds(creationIdHolder.getCreationId(), (IObjectId)permId);
        }
        this.daoFactory.setBatchUpdateMode(false);
    }

    private void reloadEntities(IOperationContext context, Map<CREATION, PE> creationToEntityMap) {
        HashSet<Long> ids = new HashSet<Long>();
        for (IIdHolder entity : creationToEntityMap.values()) {
            ids.add(entity.getId());
        }
        List<PE> entities = this.list(context, ids);
        HashMap<Long, IIdHolder> idToEntityMap = new HashMap<Long, IIdHolder>();
        for (IIdHolder iIdHolder : entities) {
            idToEntityMap.put(iIdHolder.getId(), iIdHolder);
        }
        for (Map.Entry entry : creationToEntityMap.entrySet()) {
            entry.setValue((IIdHolder)idToEntityMap.get(((IIdHolder)entry.getValue()).getId()));
        }
    }

    protected abstract IObjectId getId(PE var1);

    protected abstract void checkData(IOperationContext var1, CREATION var2);

    protected abstract void checkAccess(IOperationContext var1);

    protected abstract void checkAccess(IOperationContext var1, PE var2);

    protected abstract List<PE> createEntities(IOperationContext var1, CollectionBatch<CREATION> var2);

    protected abstract PERM_ID createPermId(IOperationContext var1, PE var2);

    protected abstract void updateBatch(IOperationContext var1, MapBatch<CREATION, PE> var2);

    protected abstract void updateAll(IOperationContext var1, MapBatch<CREATION, PE> var2);

    protected abstract List<PE> list(IOperationContext var1, Collection<Long> var2);

    protected abstract void save(IOperationContext var1, List<PE> var2, boolean var3);

    protected abstract void handleException(DataAccessException var1);
}

