/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.create.IEntityTypeCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.IPluginId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.CreatePropertyAssignmentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IPluginIdProvider;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.SetEntityTypeValidationScriptExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityTypeUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractCreateEntityTypeExecutor<CREATION extends IEntityTypeCreation, TYPE extends EntityType, TYPE_PE extends EntityTypePE>
extends AbstractCreateEntityExecutor<CREATION, TYPE_PE, EntityTypePermId> {
    @Autowired
    protected IDAOFactory daoFactory;
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private CreatePropertyAssignmentsExecutor createPropertyAssignmentsExecutor;
    @Autowired
    private SetEntityTypeValidationScriptExecutor setEntityTypeValidationScriptExecutor;

    protected abstract ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind getPEEntityKind();

    protected abstract EntityKind getDAOEntityKind();

    protected abstract TYPE newType();

    protected abstract void checkTypeSpecificFields(CREATION var1);

    protected abstract void fillTypeSpecificFields(TYPE var1, CREATION var2);

    protected abstract void defineType(IOperationContext var1, TYPE var2);

    @Override
    protected List<TYPE_PE> createEntities(final IOperationContext context, CollectionBatch<CREATION> typeCreations) {
        final LinkedList typePEs = new LinkedList();
        new CollectionBatchProcessor<CREATION>(context, typeCreations){

            @Override
            public void process(CREATION typeCreation) {
                EntityTypePE typePE = AbstractCreateEntityTypeExecutor.this.createType(context, typeCreation);
                typePEs.add(typePE);
                String entityTypeCode = typeCreation.getCode();
                List propertyAssignments = typeCreation.getPropertyAssignments();
                AbstractCreateEntityTypeExecutor.this.createPropertyAssignmentsExecutor.createPropertyAssignments(context, entityTypeCode, propertyAssignments, AbstractCreateEntityTypeExecutor.this.getPEEntityKind());
            }

            @Override
            public IProgress createProgress(CREATION object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return typePEs;
    }

    private TYPE_PE createType(IOperationContext context, CREATION typeCreation) {
        TYPE type = this.newType();
        type.setCode(typeCreation.getCode());
        ((AbstractType)((Object)type)).setDescription(typeCreation.getDescription());
        this.fillTypeSpecificFields(type, typeCreation);
        this.defineType(context, type);
        return (TYPE_PE)this.daoFactory.getEntityTypeDAO(this.getDAOEntityKind()).tryToFindEntityTypeByCode(typeCreation.getCode());
    }

    @Override
    protected EntityTypePermId createPermId(IOperationContext context, TYPE_PE entity) {
        return new EntityTypePermId(((AbstractTypePE)entity).getCode(), EntityKindConverter.convert(((EntityTypePE)entity).getEntityKind()));
    }

    @Override
    protected void checkData(IOperationContext context, CREATION creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
            throw new UserFailureException("Code cannot be empty.");
        }
        this.checkTypeSpecificFields(creation);
        EntityTypeUtils.checkPropertyAssignmentCreations(creation.getPropertyAssignments());
    }

    @Override
    protected IObjectId getId(TYPE_PE entity) {
        return null;
    }

    @Override
    protected void checkAccess(IOperationContext context, TYPE_PE entity) {
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<CREATION, TYPE_PE> batch) {
        IPluginIdProvider pluginIdProvider = new IPluginIdProvider<CREATION>(){

            @Override
            public IPluginId getPluginId(CREATION pluginIdHolder) {
                return pluginIdHolder.getValidationPluginId();
            }

            @Override
            public boolean isModified(CREATION pluginIdHolder) {
                return true;
            }
        };
        this.setEntityTypeValidationScriptExecutor.setValidationPlugin(context, batch, pluginIdProvider, this.getPEEntityKind());
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<CREATION, TYPE_PE> batch) {
    }

    @Override
    protected List<TYPE_PE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getEntityTypeDAO(this.getDAOEntityKind()).listEntityTypes();
    }

    @Override
    protected void save(IOperationContext context, List<TYPE_PE> entities, boolean clearCache) {
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, this.getDAOEntityKind().name() + "_TYPE", null);
    }
}

