/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.AbstractObjectDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IDeleteEntityExecutor;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDeleteEntityExecutor<DELETION_ID, ENTITY_ID, ENTITY_PE, DELETION_OPTIONS extends AbstractObjectDeletionOptions<?>>
implements IDeleteEntityExecutor<DELETION_ID, ENTITY_ID, DELETION_OPTIONS> {
    @Autowired
    protected IDAOFactory daoFactory;
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;

    @Override
    public DELETION_ID delete(IOperationContext context, List<? extends ENTITY_ID> entityIds, DELETION_OPTIONS deletionOptions) {
        if (context == null) {
            throw new UserFailureException("Context cannot be null");
        }
        if (entityIds == null) {
            throw new UserFailureException("Entity ids cannot be null");
        }
        if (deletionOptions == null) {
            throw new UserFailureException("Deletion options cannot be null");
        }
        if (deletionOptions.getReason() == null) {
            throw new UserFailureException("Deletion reason cannot be null");
        }
        Map<ENTITY_ID, ENTITY_PE> entityMap = this.map(context, entityIds, deletionOptions);
        if (entityMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<ENTITY_ID, ENTITY_PE> entry : entityMap.entrySet()) {
            ENTITY_ID entityId = entry.getKey();
            ENTITY_PE entity = entry.getValue();
            try {
                this.checkAccess(context, entityId, entity);
            }
            catch (AuthorizationFailureException ex) {
                throw new UnauthorizedObjectAccessException((IObjectId)entityId);
            }
            this.updateModificationDateAndModifier(context, entity);
        }
        return this.delete(context, entityMap.values(), deletionOptions);
    }

    protected List<TechId> asTechIds(Collection<? extends IIdHolder> entities) {
        ArrayList<TechId> techIds = new ArrayList<TechId>();
        for (IIdHolder iIdHolder : entities) {
            techIds.add(new TechId(HibernateUtils.getId(iIdHolder)));
        }
        return techIds;
    }

    protected abstract Map<ENTITY_ID, ENTITY_PE> map(IOperationContext var1, List<? extends ENTITY_ID> var2, DELETION_OPTIONS var3);

    protected abstract void checkAccess(IOperationContext var1, ENTITY_ID var2, ENTITY_PE var3);

    protected abstract void updateModificationDateAndModifier(IOperationContext var1, ENTITY_PE var2);

    @Override
    protected abstract DELETION_ID delete(IOperationContext var1, Collection<ENTITY_PE> var2, DELETION_OPTIONS var3);
}

