/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.AbstractEntityTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyAssignmentSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractIdMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractIdsMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.ISearchPropertyAssignmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSearchEntityTypeExecutor<ENTITY_TYPE_SEARCH_CRITERIA extends AbstractEntityTypeSearchCriteria, ENTITY_TYPE_PE extends EntityTypePE>
extends AbstractSearchObjectManuallyExecutor<ENTITY_TYPE_SEARCH_CRITERIA, ENTITY_TYPE_PE> {
    private final EntityKind entityKind;
    @Autowired
    private ISearchPropertyAssignmentExecutor searchPropertyAssignmentExecutor;

    protected AbstractSearchEntityTypeExecutor(EntityKind entityKind) {
        this.entityKind = entityKind;
    }

    @Override
    protected List<ENTITY_TYPE_PE> listAll() {
        return this.daoFactory.getEntityTypeDAO(this.entityKind).listEntityTypes();
    }

    @Override
    protected Matcher<ENTITY_TYPE_PE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof IdsSearchCriteria) {
            return new IdsMatcher();
        }
        if (criteria instanceof PermIdSearchCriteria || criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher();
        }
        if (criteria instanceof PropertyAssignmentSearchCriteria) {
            return new PropertyAssignmentMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class PropertyAssignmentMatcher
    extends Matcher<ENTITY_TYPE_PE> {
        private PropertyAssignmentMatcher() {
        }

        @Override
        public List<ENTITY_TYPE_PE> getMatching(IOperationContext context, List<ENTITY_TYPE_PE> objects, ISearchCriteria criteria) {
            List propertyAssignments = AbstractSearchEntityTypeExecutor.this.searchPropertyAssignmentExecutor.search(context, (PropertyAssignmentSearchCriteria)criteria);
            HashSet entityTypesSet = new HashSet(objects);
            HashSet<EntityTypePE> matches = new HashSet<EntityTypePE>();
            for (EntityTypePropertyTypePE propertyAssignment : propertyAssignments) {
                if (propertyAssignment.getEntityType() == null || !entityTypesSet.contains(propertyAssignment.getEntityType())) continue;
                matches.add(propertyAssignment.getEntityType());
            }
            return new ArrayList(matches);
        }
    }

    private class IdsMatcher
    extends AbstractIdsMatcher<ENTITY_TYPE_PE> {
        private IdsMatcher() {
        }

        @Override
        protected boolean addPermIdIfPossible(Collection<String> permIds, IObjectId id) {
            if (!(id instanceof EntityTypePermId)) {
                return false;
            }
            EntityTypePermId permId = (EntityTypePermId)id;
            if (permId.getPermId() == null) {
                throw new UserFailureException("Entity type perm id cannot be null");
            }
            if (permId.getEntityKind() == null || permId.getEntityKind().equals((Object)EntityKindConverter.convert(AbstractSearchEntityTypeExecutor.this.entityKind))) {
                permIds.add(permId.getPermId());
            }
            return true;
        }
    }

    private class IdMatcher
    extends AbstractIdMatcher<ENTITY_TYPE_PE> {
        private IdMatcher() {
        }

        @Override
        protected AbstractIdsMatcher<ENTITY_TYPE_PE> createIdsMatcher() {
            return new IdsMatcher();
        }
    }
}

