/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSetEntityExperimentRelationExecutor<ENTITY_CREATION extends ICreation, ENTITY_PE extends IIdentityHolder>
extends AbstractSetEntityToOneRelationExecutor<ENTITY_CREATION, ENTITY_PE, IExperimentId, ExperimentPE> {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;

    @Override
    protected Map<IExperimentId, ExperimentPE> map(IOperationContext context, List<IExperimentId> relatedIds) {
        return this.mapExperimentByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, ENTITY_PE entity, IExperimentId relatedId, ExperimentPE related) {
        if (relatedId != null && related != null) {
            ExperimentByIdentiferValidator validator = new ExperimentByIdentiferValidator();
            validator.init(new AuthorizationDataProvider(this.daoFactory));
            if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
                throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
            }
        }
    }
}

