/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSetEntitySampleRelationExecutor<ENTITY_CREATION extends ICreation, ENTITY_PE extends IIdentityHolder>
extends AbstractSetEntityToOneRelationExecutor<ENTITY_CREATION, ENTITY_PE, ISampleId, SamplePE> {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;

    @Override
    protected Map<ISampleId, SamplePE> map(IOperationContext context, List<ISampleId> relatedIds) {
        return this.mapSampleByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, ENTITY_PE entity, ISampleId relatedId, SamplePE related) {
        if (relatedId != null && related != null) {
            SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
            validator.init(new AuthorizationDataProvider(this.daoFactory));
            if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
                throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
            }
        }
    }
}

