/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.SetRelationProgress;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;

public abstract class AbstractSetEntityToManyRelationExecutor<ENTITY_CREATION extends ICreation, ENTITY_PE extends IIdentityHolder, RELATED_ID extends IObjectId, RELATED_PE> {
    @Resource(name="relationship-service")
    protected IRelationshipService relationshipService;

    public void set(final IOperationContext context, MapBatch<ENTITY_CREATION, ENTITY_PE> batch) {
        final Map<ENTITY_CREATION, Map<RELATED_ID, RELATED_PE>> relatedMap = this.getRelatedMap(context, batch);
        new MapBatchProcessor<ENTITY_CREATION, ENTITY_PE>(context, batch){

            @Override
            public void process(ENTITY_CREATION creation, ENTITY_PE entity) {
                Map relatedByIds = (Map)relatedMap.get(creation);
                if (relatedByIds != null && !relatedByIds.isEmpty()) {
                    AbstractSetEntityToManyRelationExecutor.this.setRelated(context, entity, relatedByIds.values());
                }
            }

            @Override
            public IProgress createProgress(ENTITY_CREATION creation, ENTITY_PE entity, int objectIndex, int totalObjectCount) {
                return new SetRelationProgress((IIdHolder)entity, (ICreation)creation, AbstractSetEntityToManyRelationExecutor.this.getRelationName(), objectIndex, totalObjectCount);
            }
        };
        this.postSet(context, batch, relatedMap);
    }

    private Map<ENTITY_CREATION, Map<RELATED_ID, RELATED_PE>> getRelatedMap(final IOperationContext context, MapBatch<ENTITY_CREATION, ENTITY_PE> batch) {
        final IdentityHashMap relatedMap = new IdentityHashMap();
        final HashSet toLoadIds = new HashSet();
        new MapBatchProcessor<ENTITY_CREATION, ENTITY_PE>(context, batch){

            @Override
            public void process(ENTITY_CREATION creation, ENTITY_PE entity) {
                Collection relatedIds = AbstractSetEntityToManyRelationExecutor.this.getRelatedIds(context, creation);
                if (relatedIds != null) {
                    toLoadIds.addAll(relatedIds);
                }
            }

            @Override
            public IProgress createProgress(ENTITY_CREATION creation, ENTITY_PE entity, int objectIndex, int totalObjectCount) {
                return new SetRelationProgress((IIdHolder)entity, (ICreation)creation, AbstractSetEntityToManyRelationExecutor.this.getRelationName(), objectIndex, totalObjectCount);
            }
        };
        if (!toLoadIds.isEmpty()) {
            final Map loadedMap = this.map(context, toLoadIds);
            final HashSet checked = new HashSet();
            new MapBatchProcessor<ENTITY_CREATION, ENTITY_PE>(context, batch){

                @Override
                public void process(ENTITY_CREATION creation, ENTITY_PE entity) {
                    Collection relatedIds = AbstractSetEntityToManyRelationExecutor.this.getRelatedIds(context, creation);
                    if (relatedIds != null) {
                        LinkedHashMap relatedByIds = new LinkedHashMap();
                        for (IObjectId relatedId : relatedIds) {
                            Object related = loadedMap.get(relatedId);
                            if (related == null) {
                                throw new ObjectNotFoundException(relatedId);
                            }
                            if (!checked.contains(related)) {
                                AbstractSetEntityToManyRelationExecutor.this.check(context, relatedId, related);
                                checked.add(related);
                            }
                            relatedByIds.put(relatedId, related);
                        }
                        relatedMap.put(creation, relatedByIds);
                    }
                }

                @Override
                public IProgress createProgress(ENTITY_CREATION creation, ENTITY_PE entity, int objectIndex, int totalObjectCount) {
                    return new SetRelationProgress((IIdHolder)entity, (ICreation)creation, AbstractSetEntityToManyRelationExecutor.this.getRelationName(), objectIndex, totalObjectCount);
                }
            };
        }
        return relatedMap;
    }

    protected void postSet(IOperationContext context, MapBatch<ENTITY_CREATION, ENTITY_PE> batch, Map<ENTITY_CREATION, Map<RELATED_ID, RELATED_PE>> relatedMap) {
        HashSet<RELATED_PE> allSet = new HashSet<RELATED_PE>();
        for (Map<RELATED_ID, RELATED_PE> map : relatedMap.values()) {
            allSet.addAll(map.values());
        }
        this.postSet(context, allSet);
    }

    protected void postSet(IOperationContext context, Collection<RELATED_PE> allSet) {
    }

    protected abstract RELATED_ID getCreationId(IOperationContext var1, ENTITY_CREATION var2);

    protected abstract String getRelationName();

    protected abstract Collection<? extends RELATED_ID> getRelatedIds(IOperationContext var1, ENTITY_CREATION var2);

    protected abstract Map<RELATED_ID, RELATED_PE> map(IOperationContext var1, Collection<? extends RELATED_ID> var2);

    protected abstract void check(IOperationContext var1, RELATED_ID var2, RELATED_PE var3);

    protected abstract void setRelated(IOperationContext var1, ENTITY_PE var2, Collection<RELATED_PE> var3);
}

