/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ISetEntityRelationsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.SetRelationProgress;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractSetEntityToOneRelationExecutor<ENTITY_CREATION extends ICreation, ENTITY_PE extends IIdHolder, RELATED_ID, RELATED_PE>
implements ISetEntityRelationsExecutor<ENTITY_CREATION, ENTITY_PE> {
    @Autowired
    protected IRelationshipService relationshipService;

    @Override
    public void set(final IOperationContext context, MapBatch<ENTITY_CREATION, ENTITY_PE> batch) {
        LinkedList<RELATED_ID> relatedIds = new LinkedList<RELATED_ID>();
        for (ICreation creation : ((Map)batch.getObjects()).keySet()) {
            RELATED_ID relatedId = this.getRelatedId(creation);
            if (relatedId == null) continue;
            relatedIds.add(relatedId);
        }
        final Map relatedMap = this.map(context, relatedIds);
        new MapBatchProcessor<ENTITY_CREATION, ENTITY_PE>(context, batch){

            @Override
            public void process(ENTITY_CREATION creation, ENTITY_PE entity) {
                Object relatedId = AbstractSetEntityToOneRelationExecutor.this.getRelatedId(creation);
                if (relatedId == null) {
                    AbstractSetEntityToOneRelationExecutor.this.check(context, entity, null, null);
                    AbstractSetEntityToOneRelationExecutor.this.set(context, entity, null);
                } else {
                    Object related = relatedMap.get(relatedId);
                    if (related == null) {
                        throw new ObjectNotFoundException((IObjectId)relatedId);
                    }
                    AbstractSetEntityToOneRelationExecutor.this.check(context, entity, relatedId, related);
                    AbstractSetEntityToOneRelationExecutor.this.set(context, entity, related);
                }
            }

            @Override
            public IProgress createProgress(ENTITY_CREATION creation, ENTITY_PE entity, int objectIndex, int totalObjectCount) {
                return new SetRelationProgress((IIdHolder)entity, (ICreation)creation, AbstractSetEntityToOneRelationExecutor.this.getRelationName(), objectIndex, totalObjectCount);
            }
        };
    }

    protected abstract String getRelationName();

    protected abstract RELATED_ID getRelatedId(ENTITY_CREATION var1);

    protected abstract Map<RELATED_ID, RELATED_PE> map(IOperationContext var1, List<RELATED_ID> var2);

    protected abstract void check(IOperationContext var1, ENTITY_PE var2, RELATED_ID var3, RELATED_PE var4);

    protected abstract void set(IOperationContext var1, ENTITY_PE var2, RELATED_PE var3);
}

