/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.Batch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CheckAccessProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CheckDataProgress;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;

public abstract class AbstractUpdateEntityExecutor<UPDATE extends IUpdate, PE extends IIdentityHolder, ID extends IObjectId, PERM_ID>
implements IUpdateEntityExecutor<UPDATE, PERM_ID> {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public List<PERM_ID> update(IOperationContext context, List<UPDATE> updates) {
        if (updates == null || updates.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            LinkedHashMap entitiesAll = new LinkedHashMap();
            for (CollectionBatch<UPDATE> batch : Batch.createBatches(updates)) {
                this.updateEntities(context, batch, entitiesAll);
            }
            this.reloadEntities(context, entitiesAll);
            this.updateAll(context, new MapBatch(0, 0, entitiesAll.size(), entitiesAll, entitiesAll.size()));
            this.reloadEntities(context, entitiesAll);
            ArrayList<PERM_ID> permIds = new ArrayList<PERM_ID>();
            for (IIdentityHolder entity : entitiesAll.values()) {
                permIds.add(this.getPermId(entity));
            }
            return permIds;
        }
        catch (DataAccessException e) {
            this.handleException(e);
        }
        catch (PersistenceException e) {
            Throwable endOfChain = ExceptionUtils.getEndOfChain((Throwable)e);
            throw new UserFailureException(endOfChain.getMessage(), endOfChain);
        }
        return Collections.emptyList();
    }

    private void checkData(final IOperationContext context, CollectionBatch<UPDATE> batch) {
        new CollectionBatchProcessor<UPDATE>(context, batch){

            @Override
            public void process(UPDATE object) {
                AbstractUpdateEntityExecutor.this.checkData(context, object);
            }

            @Override
            public IProgress createProgress(UPDATE object, int objectIndex, int totalObjectCount) {
                return new CheckDataProgress((IUpdate)object, objectIndex, totalObjectCount);
            }
        };
    }

    private void checkAccess(final IOperationContext context, MapBatch<UPDATE, PE> batch) {
        new MapBatchProcessor<UPDATE, PE>(context, batch){

            @Override
            public void process(UPDATE update, PE entity) {
                Object id = AbstractUpdateEntityExecutor.this.getId(update);
                try {
                    AbstractUpdateEntityExecutor.this.checkAccess(context, id, entity);
                }
                catch (AuthorizationFailureException ex) {
                    throw new UnauthorizedObjectAccessException(id);
                }
            }

            @Override
            public IProgress createProgress(UPDATE update, PE entity, int objectIndex, int totalObjectCount) {
                return new CheckAccessProgress((IIdHolder)entity, (IUpdate)update, objectIndex, totalObjectCount);
            }
        };
    }

    private Map<UPDATE, PE> getEntitiesMap(IOperationContext context, CollectionBatch<UPDATE> batch) {
        Collection entityIds = CollectionUtils.collect((Iterable)((Iterable)batch.getObjects()), (Transformer)new Transformer<UPDATE, ID>(){

            public ID transform(UPDATE update) {
                return AbstractUpdateEntityExecutor.this.getId(update);
            }
        });
        Map<ID, PE> entityMap = this.map(context, entityIds);
        for (IObjectId entityId : entityIds) {
            IIdentityHolder entity = (IIdentityHolder)entityMap.get(entityId);
            if (entity != null) continue;
            throw new ObjectNotFoundException(entityId);
        }
        HashMap<IUpdate, IIdentityHolder> result = new HashMap<IUpdate, IIdentityHolder>();
        for (IUpdate update : (Collection)batch.getObjects()) {
            ID id = this.getId(update);
            result.put(update, (IIdentityHolder)entityMap.get(id));
        }
        return result;
    }

    private void updateEntities(IOperationContext context, CollectionBatch<UPDATE> batch, Map<UPDATE, PE> entitiesAll) {
        this.checkData(context, (UPDATE)batch);
        Map<UPDATE, PE> updateToEntityMap = this.getEntitiesMap(context, batch);
        entitiesAll.putAll(updateToEntityMap);
        this.daoFactory.setBatchUpdateMode(true);
        MapBatch<UPDATE, PE> mapBatch = new MapBatch<UPDATE, PE>(batch.getBatchIndex(), batch.getFromObjectIndex(), batch.getToObjectIndex(), updateToEntityMap, batch.getTotalObjectCount());
        this.checkAccess(context, mapBatch);
        this.updateBatch(context, mapBatch);
        this.save(context, new ArrayList<PE>(updateToEntityMap.values()), false);
        this.daoFactory.setBatchUpdateMode(false);
    }

    private void reloadEntities(IOperationContext context, Map<UPDATE, PE> updateToEntityMap) {
        HashSet<Long> ids = new HashSet<Long>();
        for (IIdentityHolder entity : updateToEntityMap.values()) {
            ids.add(entity.getId());
        }
        List<PE> entities = this.list(context, ids);
        HashMap<Long, IIdentityHolder> idToEntityMap = new HashMap<Long, IIdentityHolder>();
        for (IIdentityHolder iIdentityHolder : entities) {
            idToEntityMap.put(iIdentityHolder.getId(), iIdentityHolder);
        }
        for (Map.Entry entry : updateToEntityMap.entrySet()) {
            entry.setValue((IIdentityHolder)idToEntityMap.get(((IIdentityHolder)entry.getValue()).getId()));
        }
    }

    protected <T> T getNewValue(FieldUpdateValue<T> fieldUpdateValue, T currentValue) {
        return (T)(fieldUpdateValue != null && fieldUpdateValue.isModified() ? fieldUpdateValue.getValue() : currentValue);
    }

    protected abstract ID getId(UPDATE var1);

    protected abstract PERM_ID getPermId(PE var1);

    protected abstract void checkData(IOperationContext var1, UPDATE var2);

    protected abstract void checkAccess(IOperationContext var1, ID var2, PE var3);

    protected abstract void updateBatch(IOperationContext var1, MapBatch<UPDATE, PE> var2);

    protected abstract void updateAll(IOperationContext var1, MapBatch<UPDATE, PE> var2);

    protected abstract Map<ID, PE> map(IOperationContext var1, Collection<ID> var2);

    protected abstract List<PE> list(IOperationContext var1, Collection<Long> var2);

    protected abstract void save(IOperationContext var1, List<PE> var2, boolean var3);

    protected abstract void handleException(DataAccessException var1);
}

