/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityRelationsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractUpdateEntityMultipleRelationsExecutor<ENTITY_UPDATE, ENTITY_PE, RELATED_ID, RELATED_PE>
implements IUpdateEntityRelationsExecutor<ENTITY_UPDATE, ENTITY_PE> {
    @Override
    public void update(IOperationContext context, MapBatch<ENTITY_UPDATE, ENTITY_PE> batch) {
        Map<RELATED_ID, RELATED_PE> relatedMap = this.getRelatedMap(context, ((Map)batch.getObjects()).keySet());
        this.update(context, batch, relatedMap);
    }

    private Map<RELATED_ID, RELATED_PE> getRelatedMap(IOperationContext context, Collection<ENTITY_UPDATE> updates) {
        HashSet relatedIds = new HashSet();
        for (ENTITY_UPDATE update : updates) {
            this.addRelatedIds(relatedIds, update);
        }
        if (!relatedIds.isEmpty()) {
            return this.map(context, relatedIds);
        }
        return new HashMap();
    }

    protected void addRelatedIds(Set<RELATED_ID> relatedIds, FieldUpdateValue<RELATED_ID> update) {
        if (update != null && update.isModified() && update.getValue() != null) {
            relatedIds.add(update.getValue());
        }
    }

    protected void addRelatedIds(Set<RELATED_ID> relatedIds, IdListUpdateValue<RELATED_ID> update) {
        if (update != null && update.hasActions()) {
            for (ListUpdateValue.ListUpdateAction action : update.getActions()) {
                relatedIds.addAll(action.getItems());
            }
        }
    }

    protected abstract void addRelatedIds(Set<RELATED_ID> var1, ENTITY_UPDATE var2);

    protected abstract Map<RELATED_ID, RELATED_PE> map(IOperationContext var1, Collection<RELATED_ID> var2);

    protected abstract void update(IOperationContext var1, MapBatch<ENTITY_UPDATE, ENTITY_PE> var2, Map<RELATED_ID, RELATED_PE> var3);
}

