/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityRelationsWithCacheExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Resource;

public abstract class AbstractUpdateEntityToManyRelationExecutor<ENTITY_UPDATE extends IUpdate, ENTITY_PE extends IIdentityHolder, RELATED_ID, RELATED_PE>
implements IUpdateEntityRelationsWithCacheExecutor<ENTITY_UPDATE, ENTITY_PE, RELATED_ID, RELATED_PE> {
    @Resource(name="relationship-service")
    protected IRelationshipService relationshipService;

    @Override
    public void update(final IOperationContext context, MapBatch<ENTITY_UPDATE, ENTITY_PE> batch, final Map<RELATED_ID, RELATED_PE> relatedMap) {
        final HashSet allAdded = new HashSet();
        final HashSet allRemoved = new HashSet();
        new MapBatchProcessor<ENTITY_UPDATE, ENTITY_PE>(context, batch){

            @Override
            public void process(ENTITY_UPDATE update, ENTITY_PE entity) {
                IdListUpdateValue listUpdate = AbstractUpdateEntityToManyRelationExecutor.this.getRelatedUpdate(context, update);
                if (listUpdate != null && listUpdate.hasActions()) {
                    for (ListUpdateValue.ListUpdateAction action : listUpdate.getActions()) {
                        Object related;
                        LinkedList relatedCollection = new LinkedList();
                        if (action instanceof ListUpdateValue.ListUpdateActionSet || action instanceof ListUpdateValue.ListUpdateActionAdd) {
                            for (Object relatedId : action.getItems()) {
                                related = relatedMap.get(relatedId);
                                if (related == null) {
                                    throw new ObjectNotFoundException((IObjectId)relatedId);
                                }
                                AbstractUpdateEntityToManyRelationExecutor.this.check(context, entity, relatedId, related);
                                relatedCollection.add(related);
                            }
                            if (action instanceof ListUpdateValue.ListUpdateActionSet) {
                                AbstractUpdateEntityToManyRelationExecutor.this.set(context, entity, relatedCollection, allAdded, allRemoved);
                                continue;
                            }
                            AbstractUpdateEntityToManyRelationExecutor.this.add(context, entity, relatedCollection, allAdded);
                            continue;
                        }
                        if (!(action instanceof ListUpdateValue.ListUpdateActionRemove)) continue;
                        for (Object relatedId : action.getItems()) {
                            related = relatedMap.get(relatedId);
                            if (related == null) continue;
                            relatedCollection.add(related);
                            AbstractUpdateEntityToManyRelationExecutor.this.check(context, entity, relatedId, related);
                        }
                        AbstractUpdateEntityToManyRelationExecutor.this.remove(context, entity, relatedCollection, allRemoved);
                    }
                }
                Collection relatedIds = AbstractUpdateEntityToManyRelationExecutor.this.getRelatedForRelationshipUpdate(context, update);
                for (Object relatedId : relatedIds) {
                    Object related = relatedMap.get(relatedId);
                    AbstractUpdateEntityToManyRelationExecutor.this.updateRelationships(context, update, entity, relatedId, related);
                }
            }

            @Override
            public IProgress createProgress(ENTITY_UPDATE key, ENTITY_PE value, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)key, (IIdentityHolder)value, AbstractUpdateEntityToManyRelationExecutor.this.getRelationName(), objectIndex, totalObjectCount);
            }
        };
        this.postUpdate(context, allAdded, allRemoved);
    }

    protected void postUpdate(IOperationContext context, Collection<RELATED_PE> allAdded, Collection<RELATED_PE> allRemoved) {
    }

    protected void set(IOperationContext context, ENTITY_PE entity, Collection<RELATED_PE> related, Collection<RELATED_PE> allAdded, Collection<RELATED_PE> allRemoved) {
        HashSet<RELATED_PE> existingRelated = new HashSet<RELATED_PE>(this.getCurrentlyRelated(entity));
        HashSet<RELATED_PE> newRelated = new HashSet<RELATED_PE>(related);
        for (Object anExistingRelated : existingRelated) {
            if (newRelated.contains(anExistingRelated)) continue;
            this.remove(context, entity, anExistingRelated);
            allRemoved.add(anExistingRelated);
        }
        for (Object aNewRelated : newRelated) {
            if (existingRelated.contains(aNewRelated)) continue;
            this.add(context, entity, aNewRelated);
            allAdded.add(aNewRelated);
        }
    }

    protected void add(IOperationContext context, ENTITY_PE entity, Collection<RELATED_PE> related, Collection<RELATED_PE> allAdded) {
        HashSet<RELATED_PE> existingRelated = new HashSet<RELATED_PE>(this.getCurrentlyRelated(entity));
        for (RELATED_PE aRelated : related) {
            if (existingRelated.contains(aRelated)) continue;
            this.add(context, entity, aRelated);
            allAdded.add(aRelated);
        }
    }

    protected void remove(IOperationContext context, ENTITY_PE entity, Collection<RELATED_PE> related, Collection<RELATED_PE> allRemoved) {
        HashSet<RELATED_PE> existingRelated = new HashSet<RELATED_PE>(this.getCurrentlyRelated(entity));
        for (RELATED_PE aRelated : related) {
            if (!existingRelated.contains(aRelated)) continue;
            this.remove(context, entity, aRelated);
            allRemoved.add(aRelated);
        }
    }

    protected Collection<? extends RELATED_ID> getRelatedForRelationshipUpdate(IOperationContext context, ENTITY_UPDATE update) {
        return Collections.emptySet();
    }

    protected void updateRelationships(IOperationContext context, ENTITY_UPDATE update, ENTITY_PE entity, RELATED_ID relatedId, RELATED_PE related) {
    }

    protected abstract String getRelationName();

    protected abstract Collection<RELATED_PE> getCurrentlyRelated(ENTITY_PE var1);

    protected abstract IdListUpdateValue<? extends RELATED_ID> getRelatedUpdate(IOperationContext var1, ENTITY_UPDATE var2);

    protected abstract void check(IOperationContext var1, ENTITY_PE var2, RELATED_ID var3, RELATED_PE var4);

    protected abstract void add(IOperationContext var1, ENTITY_PE var2, RELATED_PE var3);

    protected abstract void remove(IOperationContext var1, ENTITY_PE var2, RELATED_PE var3);
}

