/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityRelationsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityRelationsWithCacheExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractUpdateEntityToOneRelationExecutor<ENTITY_UPDATE extends IUpdate, ENTITY_PE extends IIdentityHolder, RELATED_ID, RELATED_PE>
implements IUpdateEntityRelationsExecutor<ENTITY_UPDATE, ENTITY_PE>,
IUpdateEntityRelationsWithCacheExecutor<ENTITY_UPDATE, ENTITY_PE, RELATED_ID, RELATED_PE> {
    @Autowired
    protected IRelationshipService relationshipService;
    @Autowired
    protected ICommonBusinessObjectFactory boFactory;

    @Override
    public void update(IOperationContext context, MapBatch<ENTITY_UPDATE, ENTITY_PE> batch) {
        LinkedList<Object> relatedIds = new LinkedList<Object>();
        for (IUpdate update : ((Map)batch.getObjects()).keySet()) {
            FieldUpdateValue<RELATED_ID> relatedUpdate = this.getRelatedUpdate(update);
            if (relatedUpdate == null || !relatedUpdate.isModified()) continue;
            relatedIds.add(relatedUpdate.getValue());
        }
        if (!relatedIds.isEmpty()) {
            Map relatedMap = this.map(context, relatedIds);
            this.updateCommon(context, batch, relatedMap);
        }
    }

    @Override
    public void update(IOperationContext context, MapBatch<ENTITY_UPDATE, ENTITY_PE> batch, Map<RELATED_ID, RELATED_PE> relatedMap) {
        this.updateCommon(context, batch, relatedMap);
    }

    private void updateCommon(final IOperationContext context, MapBatch<ENTITY_UPDATE, ENTITY_PE> batch, final Map<RELATED_ID, RELATED_PE> relatedMap) {
        final HashSet allAdded = new HashSet();
        final HashSet allRemoved = new HashSet();
        new MapBatchProcessor<ENTITY_UPDATE, ENTITY_PE>(context, batch){

            @Override
            public void process(ENTITY_UPDATE update, ENTITY_PE entity) {
                FieldUpdateValue relatedUpdate = AbstractUpdateEntityToOneRelationExecutor.this.getRelatedUpdate(update);
                Object currentlyRelated = AbstractUpdateEntityToOneRelationExecutor.this.getCurrentlyRelated(entity);
                if (relatedUpdate != null && relatedUpdate.isModified()) {
                    Object relatedId = relatedUpdate.getValue();
                    if (relatedId == null) {
                        if (currentlyRelated != null) {
                            AbstractUpdateEntityToOneRelationExecutor.this.check(context, entity, AbstractUpdateEntityToOneRelationExecutor.this.getRelatedId(currentlyRelated), currentlyRelated);
                            AbstractUpdateEntityToOneRelationExecutor.this.update(context, entity, null);
                            allRemoved.add(currentlyRelated);
                        }
                    } else {
                        Object related = relatedMap.get(relatedId);
                        if (related == null) {
                            throw new ObjectNotFoundException((IObjectId)relatedId);
                        }
                        if (!related.equals(currentlyRelated)) {
                            AbstractUpdateEntityToOneRelationExecutor.this.check(context, entity, relatedId, related);
                            AbstractUpdateEntityToOneRelationExecutor.this.update(context, entity, related);
                            allAdded.add(related);
                            if (currentlyRelated != null) {
                                allRemoved.add(currentlyRelated);
                            }
                        }
                    }
                }
            }

            @Override
            public IProgress createProgress(ENTITY_UPDATE key, ENTITY_PE value, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)key, (IIdentityHolder)value, AbstractUpdateEntityToOneRelationExecutor.this.getRelationName(), objectIndex, totalObjectCount);
            }
        };
        this.postUpdate(context, allAdded, allRemoved);
    }

    protected void postUpdate(IOperationContext context, Collection<RELATED_PE> allAdded, Collection<RELATED_PE> allRemoved) {
    }

    protected abstract String getRelationName();

    protected abstract RELATED_ID getRelatedId(RELATED_PE var1);

    protected abstract RELATED_PE getCurrentlyRelated(ENTITY_PE var1);

    protected abstract FieldUpdateValue<RELATED_ID> getRelatedUpdate(ENTITY_UPDATE var1);

    protected abstract Map<RELATED_ID, RELATED_PE> map(IOperationContext var1, List<RELATED_ID> var2);

    protected abstract void check(IOperationContext var1, ENTITY_PE var2, RELATED_ID var3, RELATED_PE var4);

    protected abstract void update(IOperationContext var1, ENTITY_PE var2, RELATED_PE var3);
}

