/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.update.IEntityTypeUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.update.PropertyAssignmentListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.IPluginId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IMapEntityTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IPluginIdProvider;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityTypePropertyTypesExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.SetEntityTypeValidationScriptExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityTypeUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractUpdateEntityTypeExecutor<UPDATE extends IEntityTypeUpdate, TYPE_PE extends EntityTypePE>
extends AbstractUpdateEntityExecutor<UPDATE, TYPE_PE, IEntityTypeId, EntityTypePermId> {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapEntityTypeByIdExecutor mapEntityTypeByIdExecutor;
    @Autowired
    private SetEntityTypeValidationScriptExecutor setEntityTypeValidationScriptExecutor;

    protected abstract EntityKind getDAOEntityKind();

    protected abstract void checkTypeSpecificFields(UPDATE var1);

    protected abstract IUpdateEntityTypePropertyTypesExecutor<UPDATE, TYPE_PE> getUpdateEntityTypePropertyTypeExecutor();

    @Override
    protected IEntityTypeId getId(UPDATE update) {
        return update.getTypeId();
    }

    @Override
    protected EntityTypePermId getPermId(TYPE_PE entity) {
        return new EntityTypePermId(((AbstractTypePE)entity).getCode(), EntityKindConverter.convert(((EntityTypePE)entity).getEntityKind()));
    }

    @Override
    protected void checkData(IOperationContext context, UPDATE update) {
        IEntityTypeId id = update.getTypeId();
        if (id == null) {
            throw new UserFailureException("Missing type id.");
        }
        if (id instanceof EntityTypePermId) {
            EntityTypePermId entityTypePermId = (EntityTypePermId)id;
            ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind entityKind = EntityKindConverter.convert(this.getDAOEntityKind());
            if (entityTypePermId.getEntityKind() == null) {
                update.setTypeId((IEntityTypeId)new EntityTypePermId(entityTypePermId.getPermId(), entityKind));
            } else if (!entityTypePermId.getEntityKind().equals((Object)entityKind)) {
                throw new UserFailureException("Entity kind " + entityKind + " expected: " + id);
            }
        }
        this.checkTypeSpecificFields(update);
        PropertyAssignmentListUpdateValue propertyAssignments = update.getPropertyAssignments();
        if (propertyAssignments != null) {
            EntityTypeUtils.checkPropertyAssignmentCreations(propertyAssignments.getAdded());
        }
    }

    @Override
    protected Map<IEntityTypeId, TYPE_PE> map(IOperationContext context, Collection<IEntityTypeId> ids) {
        Map<IEntityTypeId, EntityTypePE> map = this.mapEntityTypeByIdExecutor.map(context, this.getDAOEntityKind(), ids);
        return map;
    }

    @Override
    protected List<TYPE_PE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getEntityTypeDAO(this.getDAOEntityKind()).listEntityTypes();
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<UPDATE, TYPE_PE> batch) {
        IPluginIdProvider pluginIdProvider = new IPluginIdProvider<UPDATE>(){

            @Override
            public IPluginId getPluginId(UPDATE pluginIdHolder) {
                return (IPluginId)pluginIdHolder.getValidationPluginId().getValue();
            }

            @Override
            public boolean isModified(UPDATE pluginIdHolder) {
                return pluginIdHolder.getValidationPluginId().isModified();
            }
        };
        this.setEntityTypeValidationScriptExecutor.setValidationPlugin(context, batch, pluginIdProvider, DtoConverters.convertEntityKind(this.getDAOEntityKind()));
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            IEntityTypeUpdate update = (IEntityTypeUpdate)entry.getKey();
            EntityTypePE type = (EntityTypePE)entry.getValue();
            type.setDescription(this.getNewValue(update.getDescription(), type.getDescription()));
            this.updateSpecific(type, update);
        }
    }

    protected void updateSpecific(TYPE_PE type, UPDATE update) {
    }

    @Override
    protected <T> T getNewValue(FieldUpdateValue<T> fieldUpdateValue, T currentValue) {
        return (T)(fieldUpdateValue != null && fieldUpdateValue.isModified() ? fieldUpdateValue.getValue() : currentValue);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<UPDATE, TYPE_PE> batch) {
        this.getUpdateEntityTypePropertyTypeExecutor().update(context, batch);
    }

    @Override
    protected void save(IOperationContext context, List<TYPE_PE> entities, boolean clearCache) {
        for (EntityTypePE entityType : entities) {
            this.daoFactory.getEntityTypeDAO(this.getDAOEntityKind()).createOrUpdateEntityType(entityType);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, this.getDAOEntityKind().name() + "_TYPE", null);
    }
}

