/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.update.IEntityTypeUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.update.PropertyAssignmentListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.create.PropertyAssignmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.CreatePropertyAssignmentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IUpdateEntityTypePropertyTypesExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IMapPropertyAssignmentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IEntityTypePropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.InternalPropertyTypeAuthorization;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentityHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractUpdateEntityTypePropertyTypesExecutor<UPDATE extends IEntityTypeUpdate, TYPE_PE extends EntityTypePE, ETPT_PE extends EntityTypePropertyTypePE>
implements IUpdateEntityTypePropertyTypesExecutor<UPDATE, TYPE_PE> {
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private CreatePropertyAssignmentsExecutor createPropertyAssignmentsExecutor;
    @Autowired
    private IMapPropertyAssignmentByIdExecutor mapPropertyAssignmentByIdExecutor;

    protected abstract EntityKind getEntityKind();

    @Override
    public void update(final IOperationContext context, MapBatch<UPDATE, TYPE_PE> batch) {
        new MapBatchProcessor<UPDATE, TYPE_PE>(context, batch){

            @Override
            public void process(UPDATE update, TYPE_PE typePE) {
                PropertyAssignmentListUpdateValue propertyAssignments = update.getPropertyAssignments();
                AbstractUpdateEntityTypePropertyTypesExecutor.this.update(context, typePE, propertyAssignments);
            }

            @Override
            public IProgress createProgress(UPDATE key, TYPE_PE value, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)key, (IIdentityHolder)value, "entity-type-property-type", objectIndex, totalObjectCount);
            }
        };
    }

    private void update(IOperationContext context, TYPE_PE typePE, PropertyAssignmentListUpdateValue updates) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (typePE == null) {
            throw new IllegalArgumentException("Entity type cannot be null");
        }
        if (updates != null && updates.hasActions()) {
            this.remove(context, typePE, updates);
            this.add(context, typePE, updates);
            this.set(context, typePE, updates);
        }
    }

    private void remove(IOperationContext context, TYPE_PE typePE, PropertyAssignmentListUpdateValue updates) {
        HashSet removed = new HashSet();
        for (ListUpdateValue.ListUpdateAction updateAction : updates.getActions()) {
            if (!(updateAction instanceof ListUpdateValue.ListUpdateActionRemove)) continue;
            removed.addAll(updateAction.getItems());
        }
        if (!removed.isEmpty()) {
            Map map = this.mapPropertyAssignmentByIdExecutor.map(context, removed);
            boolean forceRemovingAssignments = updates.isForceRemovingAssignments();
            this.removeAssignments(context, map.values(), forceRemovingAssignments);
        }
    }

    private void add(IOperationContext context, TYPE_PE typePE, PropertyAssignmentListUpdateValue updates) {
        HashSet added = new HashSet();
        for (ListUpdateValue.ListUpdateAction updateAction : updates.getActions()) {
            if (!(updateAction instanceof ListUpdateValue.ListUpdateActionAdd)) continue;
            added.addAll(updateAction.getItems());
        }
        if (!added.isEmpty()) {
            this.createPropertyAssignmentsExecutor.createPropertyAssignments(context, ((AbstractTypePE)typePE).getCode(), added, this.getEntityKind());
        }
    }

    private void set(IOperationContext context, TYPE_PE typePE, PropertyAssignmentListUpdateValue updates) {
        ListUpdateValue.ListUpdateActionSet lastSet = null;
        for (ListUpdateValue.ListUpdateAction action : updates.getActions()) {
            if (!(action instanceof ListUpdateValue.ListUpdateActionSet)) continue;
            lastSet = (ListUpdateValue.ListUpdateActionSet)action;
        }
        if (lastSet != null) {
            Collection creations = lastSet.getItems();
            ArrayList<PropertyAssignmentCreation> replacements = new ArrayList<PropertyAssignmentCreation>();
            ArrayList<PropertyAssignmentCreation> newCreations = new ArrayList<PropertyAssignmentCreation>();
            boolean forceRemovingAssignments = updates.isForceRemovingAssignments();
            this.findReplacementsNewCreationsAndDeleteAssignments(context, typePE, creations, replacements, newCreations, forceRemovingAssignments);
            if (!newCreations.isEmpty()) {
                this.createPropertyAssignmentsExecutor.createPropertyAssignments(context, ((AbstractTypePE)typePE).getCode(), newCreations, this.getEntityKind());
            }
            if (!replacements.isEmpty()) {
                for (PropertyAssignmentCreation replacement : replacements) {
                    NewETPTAssignment translatedAssignment = this.createPropertyAssignmentsExecutor.translateAssignment(context, ((AbstractTypePE)typePE).getCode(), this.getEntityKind(), replacement);
                    IEntityTypePropertyTypeBO etptBO = this.businessObjectFactory.createEntityTypePropertyTypeBO(context.getSession(), DtoConverters.convertEntityKind(this.getEntityKind()));
                    etptBO.loadAssignment(translatedAssignment.getPropertyTypeCode(), translatedAssignment.getEntityTypeCode());
                    etptBO.updateLoadedAssignment(translatedAssignment);
                }
            }
        }
    }

    private void findReplacementsNewCreationsAndDeleteAssignments(IOperationContext context, TYPE_PE typePE, Collection<? extends PropertyAssignmentCreation> creations, List<PropertyAssignmentCreation> replacements, List<PropertyAssignmentCreation> newCreations, boolean forceRemovingAssignments) {
        Map<String, EntityTypePropertyTypePE> currentAssignments = this.getCurrentAssignments(typePE);
        for (PropertyAssignmentCreation propertyAssignmentCreation : creations) {
            IPropertyTypeId propertyTypeId = propertyAssignmentCreation.getPropertyTypeId();
            if (propertyTypeId instanceof PropertyTypePermId) {
                String propertyTypeCode = ((PropertyTypePermId)propertyTypeId).getPermId();
                if (currentAssignments.remove(propertyTypeCode) != null) {
                    replacements.add(propertyAssignmentCreation);
                    continue;
                }
                newCreations.add(propertyAssignmentCreation);
                continue;
            }
            if (propertyTypeId == null) {
                throw new UserFailureException("PropertyTypeId cannot be null.");
            }
            throw new UserFailureException("Unknown type of property type id: " + propertyTypeId.getClass().getName());
        }
        this.removeAssignments(context, currentAssignments.values(), forceRemovingAssignments);
    }

    private Map<String, EntityTypePropertyTypePE> getCurrentAssignments(TYPE_PE typePE) {
        Collection<? extends EntityTypePropertyTypePE> entityTypePropertyTypes = ((EntityTypePE)typePE).getEntityTypePropertyTypes();
        HashMap<String, EntityTypePropertyTypePE> etptByPropertyTypeCode = new HashMap<String, EntityTypePropertyTypePE>();
        for (EntityTypePropertyTypePE entityTypePropertyTypePE : entityTypePropertyTypes) {
            String code = entityTypePropertyTypePE.getPropertyType().getCode();
            etptByPropertyTypeCode.put(code, entityTypePropertyTypePE);
        }
        return etptByPropertyTypeCode;
    }

    private void removeAssignments(IOperationContext context, Collection<EntityTypePropertyTypePE> etpts, boolean forceRemovingAssignments) {
        for (EntityTypePropertyTypePE entityTypePropertyType : etpts) {
            if (forceRemovingAssignments || entityTypePropertyType.getPropertyValues().isEmpty()) {
                new InternalPropertyTypeAuthorization().canDeletePropertyAssignment(context.getSession(), entityTypePropertyType.getPropertyType(), entityTypePropertyType);
                entityTypePropertyType.getEntityType().getEntityTypePropertyTypes().remove(entityTypePropertyType);
                continue;
            }
            throw new UserFailureException("Can not remove property type " + entityTypePropertyType.getPropertyType().getCode() + " from type " + entityTypePropertyType.getEntityType().getCode() + " because " + entityTypePropertyType.getPropertyValues().size() + " entites using this property. To force removal call getPropertyAssignments().setForceRemovingAssignments(true) on the entity update object.");
        }
    }
}

