/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IVerifyEntityRelationsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.systemsx.cisd.common.collection.CycleFoundException;
import ch.systemsx.cisd.common.collection.GroupingDAG;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractVerifyEntityCyclesExecutor<ENTITY_PE>
implements IVerifyEntityRelationsExecutor<ENTITY_PE> {
    @Autowired
    protected IDAOFactory daoFactory;

    @Override
    public void verify(IOperationContext context, CollectionBatch<ENTITY_PE> batch) {
        Map<Long, Collection<Long>> graph = this.getGraph(context, (Collection)batch.getObjects());
        this.checkCycles(graph);
    }

    private Map<Long, Collection<Long>> getGraph(IOperationContext context, Collection<ENTITY_PE> entities) {
        LinkedHashMap<Long, Collection<Long>> relationsMap = new LinkedHashMap<Long, Collection<Long>>();
        HashSet<Long> currentLevelIds = new HashSet<Long>();
        HashSet<Long> visitedIds = new HashSet<Long>();
        for (ENTITY_PE entity : entities) {
            Long entityId = this.getId(entity);
            currentLevelIds.add(entityId);
        }
        while (!currentLevelIds.isEmpty()) {
            Map<Long, Set<Long>> relatedIdsMap = this.getRelatedIdsMap(context, currentLevelIds);
            visitedIds.addAll(currentLevelIds);
            currentLevelIds = new HashSet();
            for (Map.Entry<Long, Set<Long>> relatedIdsEntry : relatedIdsMap.entrySet()) {
                Long entityId = relatedIdsEntry.getKey();
                Set<Long> relatedIds = relatedIdsEntry.getValue();
                relationsMap.put(entityId, relatedIds);
                for (Long relatedId : relatedIds) {
                    if (visitedIds.contains(relatedId)) continue;
                    currentLevelIds.add(relatedId);
                }
            }
        }
        return relationsMap;
    }

    private void checkCycles(Map<Long, Collection<Long>> graph) {
        try {
            GroupingDAG.groupByDepencies(graph);
        }
        catch (CycleFoundException e) {
            Long entityId = (Long)e.getCycleRoot();
            String entityIdentifier = this.getIdentifier(entityId);
            throw new UserFailureException("Circular dependency found: " + entityIdentifier, (Throwable)e);
        }
    }

    protected abstract Long getId(ENTITY_PE var1);

    protected abstract String getIdentifier(Long var1);

    protected abstract Map<Long, Set<Long>> getRelatedIdsMap(IOperationContext var1, Set<Long> var2);
}

