/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entity.create.CreateCodesOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entity.create.CreateCodesOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.OperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ICreateCodesOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IEntityAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateCodesOperationExecutor
extends OperationExecutor<CreateCodesOperation, CreateCodesOperationResult>
implements ICreateCodesOperationExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IEntityAuthorizationExecutor authorizationExecutor;

    @Override
    protected Class<? extends CreateCodesOperation> getOperationClass() {
        return CreateCodesOperation.class;
    }

    @Override
    protected CreateCodesOperationResult doExecute(IOperationContext context, CreateCodesOperation operation) {
        if (operation.getEntityKind() == null) {
            throw new UserFailureException("Entity kind cannot be null");
        }
        if (operation.getCount() <= 0) {
            throw new UserFailureException("Count cannot be <= 0");
        }
        this.authorizationExecutor.canCreateCodes(context);
        List<String> codes = new EntityCodeGenerator(this.daoFactory).generateCodes(operation.getPrefix() != null ? operation.getPrefix() : "", EntityKind.valueOf((String)operation.getEntityKind().name()), operation.getCount());
        return new CreateCodesOperationResult(codes);
    }
}

