/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entity.create.CreatePermIdsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entity.create.CreatePermIdsOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.OperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ICreatePermIdsOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IEntityAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePermIdsOperationExecutor
extends OperationExecutor<CreatePermIdsOperation, CreatePermIdsOperationResult>
implements ICreatePermIdsOperationExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IEntityAuthorizationExecutor authorizationExecutor;

    @Override
    protected Class<? extends CreatePermIdsOperation> getOperationClass() {
        return CreatePermIdsOperation.class;
    }

    @Override
    protected CreatePermIdsOperationResult doExecute(IOperationContext context, CreatePermIdsOperation operation) {
        int count = operation.getCount();
        if (count <= 0) {
            throw new UserFailureException("Count cannot be <= 0");
        }
        if (count > 100) {
            throw new UserFailureException("Cannot create more than 100 ids in one call (" + count + " requested)");
        }
        this.authorizationExecutor.canCreatePermIds(context);
        return new CreatePermIdsOperationResult(this.daoFactory.getPermIdDAO().createPermIds(count));
    }
}

