/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.IPluginId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.create.PropertyAssignmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IMapPluginByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IMapPropertyTypeByIdExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IEntityTypePropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePropertyAssignmentsExecutor {
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IMapPropertyTypeByIdExecutor mapPropertyTypeByIdExecutor;
    @Autowired
    private IMapPluginByIdExecutor mapPluginByIdExecutor;

    public void createPropertyAssignments(IOperationContext context, String entityTypeCode, Collection<? extends PropertyAssignmentCreation> propertyAssignments, EntityKind entityKind) {
        if (propertyAssignments != null) {
            ArrayList<? extends PropertyAssignmentCreation> assignmentCreations = new ArrayList<PropertyAssignmentCreation>();
            assignmentCreations.addAll(propertyAssignments);
            Collections.sort(assignmentCreations, new Comparator<PropertyAssignmentCreation>(){

                @Override
                public int compare(PropertyAssignmentCreation o1, PropertyAssignmentCreation o2) {
                    int ordinal1 = o1.getOrdinal() != null ? o1.getOrdinal() : Integer.MAX_VALUE;
                    int ordinal2 = o2.getOrdinal() != null ? o2.getOrdinal() : Integer.MAX_VALUE;
                    return Integer.compare(ordinal1, ordinal2);
                }
            });
            for (PropertyAssignmentCreation propertyAssignmentCreation : assignmentCreations) {
                this.createPropertyAssignments(context, entityTypeCode, entityKind, propertyAssignmentCreation);
            }
        }
    }

    private void createPropertyAssignments(IOperationContext context, String entityTypeCode, EntityKind entityKind, PropertyAssignmentCreation assignmentCreation) {
        NewETPTAssignment assignment = this.translateAssignment(context, entityTypeCode, entityKind, assignmentCreation);
        IEntityTypePropertyTypeBO propertyBO = this.businessObjectFactory.createEntityTypePropertyTypeBO(context.getSession(), DtoConverters.convertEntityKind(entityKind));
        propertyBO.createAssignment(assignment);
    }

    public NewETPTAssignment translateAssignment(IOperationContext context, String entityTypeCode, EntityKind entityKind, PropertyAssignmentCreation assignmentCreation) {
        NewETPTAssignment assignment = new NewETPTAssignment();
        assignment.setEntityKind(entityKind);
        PropertyTypePE propertyTypePE = this.findPropertyType(context, assignmentCreation.getPropertyTypeId());
        assignment.setPropertyTypeCode(propertyTypePE.getCode());
        assignment.setEntityTypeCode(entityTypeCode);
        assignment.setMandatory(assignmentCreation.isMandatory());
        assignment.setDefaultValue(assignmentCreation.getInitialValueForExistingEntities());
        assignment.setSection(assignmentCreation.getSection());
        if (assignmentCreation.getOrdinal() != null) {
            assignment.setOrdinal((long)assignmentCreation.getOrdinal().intValue() - 1L);
        }
        if (assignmentCreation.getPluginId() != null) {
            ScriptPE pluginPE = this.findPlugin(context, assignmentCreation.getPluginId());
            if (!ScriptType.DYNAMIC_PROPERTY.equals(pluginPE.getScriptType()) && !ScriptType.MANAGED_PROPERTY.equals(pluginPE.getScriptType())) {
                throw new UserFailureException("Property assignment plugin has to be of type '" + ScriptType.DYNAMIC_PROPERTY + "' or '" + ScriptType.MANAGED_PROPERTY + "'. The specified plugin with id '" + assignmentCreation.getPluginId() + "' is of type '" + pluginPE.getScriptType() + "'.");
            }
            if (pluginPE.getEntityKind() != null && !pluginPE.getEntityKind().equals((Object)entityKind)) {
                throw new UserFailureException("Property assignment plugin has entity kind set to '" + pluginPE.getEntityKind() + "'. Expected a plugin where entity kind is either '" + entityKind + "' or null.");
            }
            assignment.setScriptName(pluginPE.getName());
            assignment.setDynamic(ScriptType.DYNAMIC_PROPERTY.equals(pluginPE.getScriptType()));
            assignment.setManaged(ScriptType.MANAGED_PROPERTY.equals(pluginPE.getScriptType()));
        }
        assignment.setShownInEditView(assignmentCreation.isShowInEditView());
        assignment.setShowRawValue(assignmentCreation.isShowRawValueInForms());
        return assignment;
    }

    private ScriptPE findPlugin(IOperationContext context, IPluginId pluginId) {
        Map pluginPEMap = this.mapPluginByIdExecutor.map(context, Arrays.asList(pluginId));
        ScriptPE pluginPE = (ScriptPE)pluginPEMap.get(pluginId);
        if (pluginPE == null) {
            throw new ObjectNotFoundException((IObjectId)pluginId);
        }
        return pluginPE;
    }

    private PropertyTypePE findPropertyType(IOperationContext context, IPropertyTypeId propertyTypeId) {
        Map propertyTypePEMap = this.mapPropertyTypeByIdExecutor.map(context, Arrays.asList(propertyTypeId));
        PropertyTypePE propertyTypePE = (PropertyTypePE)propertyTypePEMap.get(propertyTypeId);
        if (propertyTypePE == null) {
            throw new ObjectNotFoundException((IObjectId)propertyTypeId);
        }
        return propertyTypePE;
    }
}

