/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IMapEntityTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material.IMaterialTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.MapObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.ListEntityTypeByPermId;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapEntityTypeByIdExecutor
implements IMapEntityTypeByIdExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IExperimentTypeAuthorizationExecutor experimentTypeAuthorizationExecutor;
    @Autowired
    private ISampleTypeAuthorizationExecutor sampleTypeAuthorizationExecutor;
    @Autowired
    private IDataSetTypeAuthorizationExecutor dataSetTypeAuthorizationExecutor;
    @Autowired
    private IMaterialTypeAuthorizationExecutor materialTypeAuthorizationExecutor;

    private MapEntityTypeByIdExecutor() {
    }

    public MapEntityTypeByIdExecutor(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public Map<IEntityTypeId, EntityTypePE> map(IOperationContext context, EntityKind entityKind, Collection<? extends IEntityTypeId> entityTypeIds) {
        ArrayList<EntityTypePermId> entityTypeIdsWithEntityKinds = new ArrayList<EntityTypePermId>();
        IdentityHashMap<EntityTypePermId, IEntityTypeId> entityTypeIdMapping = new IdentityHashMap<EntityTypePermId, IEntityTypeId>();
        if (entityTypeIds != null) {
            for (IEntityTypeId iEntityTypeId : entityTypeIds) {
                if (iEntityTypeId == null) continue;
                if (iEntityTypeId instanceof EntityTypePermId) {
                    EntityTypePermId entityTypePermId = (EntityTypePermId)iEntityTypeId;
                    EntityTypePermId entityTypeIdWithEntityKind = null;
                    if (entityKind == null) {
                        if (entityTypePermId.getEntityKind() == null) {
                            throw new UserFailureException("Entity type entity kind cannot be null");
                        }
                        entityTypeIdWithEntityKind = entityTypePermId;
                    } else if (entityTypePermId.getEntityKind() == null) {
                        entityTypeIdWithEntityKind = new EntityTypePermId(entityTypePermId.getPermId(), EntityKindConverter.convert(entityKind));
                    } else if (entityKind.equals((Object)EntityKindConverter.convert(entityTypePermId.getEntityKind()))) {
                        entityTypeIdWithEntityKind = entityTypePermId;
                    } else {
                        throw new UserFailureException("Incorrect entity type entity kind. Expected '" + (Object)((Object)entityKind) + "' but was '" + entityTypePermId.getEntityKind() + "'.");
                    }
                    entityTypeIdsWithEntityKinds.add(entityTypeIdWithEntityKind);
                    entityTypeIdMapping.put(entityTypeIdWithEntityKind, iEntityTypeId);
                    continue;
                }
                throw new UnsupportedObjectIdException((IObjectId)iEntityTypeId);
            }
        }
        this.checkAccess(context, entityTypeIdsWithEntityKinds);
        LinkedList listers = new LinkedList();
        listers.add(new ListEntityTypeByPermId(this.daoFactory));
        Map map = new MapObjectById().map(context, listers, entityTypeIdsWithEntityKinds);
        LinkedHashMap<IEntityTypeId, EntityTypePE> mapWithOriginalIds = new LinkedHashMap<IEntityTypeId, EntityTypePE>();
        for (Map.Entry entry : map.entrySet()) {
            IEntityTypeId modifiedId = (IEntityTypeId)entry.getKey();
            IEntityTypeId originalId = (IEntityTypeId)entityTypeIdMapping.get(modifiedId);
            mapWithOriginalIds.put(originalId, (EntityTypePE)entry.getValue());
        }
        return mapWithOriginalIds;
    }

    private void checkAccess(IOperationContext context, Collection<? extends IEntityTypeId> entityTypeIds) {
        HashSet<ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind> entityKinds = new HashSet<ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind>();
        for (IEntityTypeId iEntityTypeId : entityTypeIds) {
            entityKinds.add(((EntityTypePermId)iEntityTypeId).getEntityKind());
        }
        if (entityKinds.contains(ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind.EXPERIMENT)) {
            this.experimentTypeAuthorizationExecutor.canGet(context);
        }
        if (entityKinds.contains(ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind.SAMPLE)) {
            this.sampleTypeAuthorizationExecutor.canGet(context);
        }
        if (entityKinds.contains(ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind.DATA_SET)) {
            this.dataSetTypeAuthorizationExecutor.canGet(context);
        }
        if (entityKinds.contains(ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind.MATERIAL)) {
            this.materialTypeAuthorizationExecutor.canGet(context);
        }
    }
}

