/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IReindexEntityExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReindexEntityExecutor
implements IReindexEntityExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public <T extends IEntityInformationWithPropertiesHolder> void reindex(IOperationContext context, Class<T> objectClass, Collection<T> objects) {
        IDynamicPropertyEvaluationScheduler indexUpdater = this.daoFactory.getPersistencyResources().getDynamicPropertyEvaluationScheduler();
        ArrayList<Long> objectIds = new ArrayList<Long>();
        for (IIdHolder object : objects) {
            if (object == null || object.getId() == null) continue;
            objectIds.add(object.getId());
        }
        if (!objectIds.isEmpty()) {
            indexUpdater.scheduleUpdate(DynamicPropertyEvaluationOperation.evaluate(objectClass, objectIds));
        }
    }
}

