/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.EntityKindSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.EntityTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.dataset.IDataSetTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ISearchEntityTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.material.IMaterialTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchEntityTypeExecutor
extends AbstractSearchObjectManuallyExecutor<EntityTypeSearchCriteria, EntityTypePE>
implements ISearchEntityTypeExecutor {
    @Autowired
    private IMaterialTypeAuthorizationExecutor materialTypeAuthorizationExecutor;
    @Autowired
    private IExperimentTypeAuthorizationExecutor experimentTypeAuthorizationExecutor;
    @Autowired
    private ISampleTypeAuthorizationExecutor sampleTypeAuthorizationExecutor;
    @Autowired
    private IDataSetTypeAuthorizationExecutor dataSetTypeAuthorizationExecutor;

    @Override
    public List<EntityTypePE> search(IOperationContext context, EntityTypeSearchCriteria criteria) {
        this.materialTypeAuthorizationExecutor.canSearch(context);
        this.experimentTypeAuthorizationExecutor.canSearch(context);
        this.sampleTypeAuthorizationExecutor.canSearch(context);
        this.dataSetTypeAuthorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<EntityTypePE> listAll() {
        ArrayList<EntityTypePE> entityTypes = new ArrayList<EntityTypePE>();
        entityTypes.addAll(this.daoFactory.getEntityTypeDAO(EntityKind.MATERIAL).listAllEntities());
        entityTypes.addAll(this.daoFactory.getEntityTypeDAO(EntityKind.EXPERIMENT).listAllEntities());
        entityTypes.addAll(this.daoFactory.getEntityTypeDAO(EntityKind.SAMPLE).listAllEntities());
        entityTypes.addAll(this.daoFactory.getEntityTypeDAO(EntityKind.DATA_SET).listAllEntities());
        return entityTypes;
    }

    @Override
    protected Matcher<EntityTypePE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<EntityTypePE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<EntityTypePE>();
        }
        if (criteria instanceof EntityKindSearchCriteria) {
            return new EntityKindMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class EntityKindMatcher
    extends SimpleFieldMatcher<EntityTypePE> {
        private EntityKindMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, EntityTypePE object, ISearchCriteria criteria) {
            EntityKind entityKind = EntityKindConverter.convert((ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind)((EntityKindSearchCriteria)criteria).getFieldValue());
            if (entityKind == null) {
                return true;
            }
            return entityKind.equals((Object)object.getEntityKind());
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<EntityTypePE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, EntityTypePE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof EntityTypePermId) {
                EntityTypePermId permId = (EntityTypePermId)id;
                if (permId.getPermId() == null) {
                    throw new UserFailureException("Entity type perm id cannot be null");
                }
                if (permId.getEntityKind() == null) {
                    throw new UserFailureException("Entity type entity kind cannot be null");
                }
                return permId.getPermId().equals(object.getPermId()) && permId.getEntityKind().equals((Object)EntityKindConverter.convert(object.getEntityKind()));
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

