/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.IPluginId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IPluginIdProvider;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.plugin.IMapPluginByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.EntityProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetEntityTypeValidationScriptExecutor {
    @Autowired
    private IMapPluginByIdExecutor mapPluginByIdExecutor;

    public <T, PE extends EntityTypePE> void setValidationPlugin(IOperationContext context, MapBatch<T, PE> batch, final IPluginIdProvider<T> pluginIdProvider, final EntityKind entityKind) {
        final Map<IPluginId, ScriptPE> pluginsById = this.getPlugins(context, batch, pluginIdProvider);
        new MapBatchProcessor<T, PE>(context, batch){

            @Override
            public void process(T key, PE value) {
                IPluginId validationPluginId = pluginIdProvider.getPluginId(key);
                if (pluginIdProvider.isModified(key)) {
                    ScriptPE pluginPE = null;
                    if (validationPluginId != null) {
                        pluginPE = (ScriptPE)pluginsById.get(validationPluginId);
                        if (pluginPE == null) {
                            throw new ObjectNotFoundException((IObjectId)validationPluginId);
                        }
                        SetEntityTypeValidationScriptExecutor.this.checkScriptType(pluginPE, validationPluginId);
                        SetEntityTypeValidationScriptExecutor.this.checkEntityKind(pluginPE, entityKind);
                    }
                    ((EntityTypePE)value).setValidationScript(pluginPE);
                }
            }

            @Override
            public IProgress createProgress(T key, PE value, int objectIndex, int totalObjectCount) {
                return new EntityProgress("setting validation script", (IIdHolder)value, objectIndex, totalObjectCount);
            }
        };
    }

    private <T, PE extends EntityTypePE> Map<IPluginId, ScriptPE> getPlugins(IOperationContext context, MapBatch<T, PE> batch, final IPluginIdProvider<T> pluginIdProvider) {
        final HashSet pluginIds = new HashSet();
        new MapBatchProcessor<T, PE>(context, batch){

            @Override
            public void process(T key, PE value) {
                IPluginId validationPluginId = pluginIdProvider.getPluginId(key);
                if (validationPluginId != null) {
                    pluginIds.add(validationPluginId);
                }
            }

            @Override
            public IProgress createProgress(T key, PE value, int objectIndex, int totalObjectCount) {
                return new EntityProgress("getting validation script", (IIdHolder)value, objectIndex, totalObjectCount);
            }
        };
        return this.mapPluginByIdExecutor.map(context, pluginIds);
    }

    private void checkScriptType(ScriptPE pluginPE, IPluginId validationPluginId) {
        if (!ScriptType.ENTITY_VALIDATION.equals(pluginPE.getScriptType())) {
            throw new UserFailureException("Entity type validation plugin has to be of type '" + ScriptType.ENTITY_VALIDATION + "'. The specified plugin with id '" + validationPluginId + "' is of type '" + pluginPE.getScriptType() + "'.");
        }
    }

    private void checkEntityKind(ScriptPE pluginPE, EntityKind entityKind) {
        if (pluginPE.getEntityKind() != null && !pluginPE.getEntityKind().equals((Object)entityKind)) {
            throw new UserFailureException("Entity type validation plugin has entity kind set to '" + pluginPE.getEntityKind() + "'. Expected a plugin where entity kind is either '" + entityKind + "' or null.");
        }
    }
}

