/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.create.AttachmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.create.ExperimentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.ICreateAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.ICreateExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.ISetExperimentProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.ISetExperimentTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IUpdateEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IAddTagToEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateExperimentExecutor
extends AbstractCreateEntityExecutor<ExperimentCreation, ExperimentPE, ExperimentPermId>
implements ICreateExperimentExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IExperimentAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ISetExperimentTypeExecutor setExperimentTypeExecutor;
    @Autowired
    private ISetExperimentProjectExecutor setExperimentProjectExecutor;
    @Autowired
    private IUpdateEntityPropertyExecutor updateEntityPropertyExecutor;
    @Autowired
    private ICreateAttachmentExecutor createAttachmentExecutor;
    @Autowired
    private IAddTagToEntityExecutor addTagToEntityExecutor;

    @Override
    protected List<ExperimentPE> createEntities(IOperationContext context, CollectionBatch<ExperimentCreation> batch) {
        final LinkedList<ExperimentPE> experiments = new LinkedList<ExperimentPE>();
        final PersonPE person = context.getSession().tryGetPerson();
        final Date timeStamp = this.daoFactory.getTransactionTimestamp();
        new CollectionBatchProcessor<ExperimentCreation>(context, batch){

            @Override
            public void process(ExperimentCreation object) {
                ExperimentPE experiment = new ExperimentPE();
                experiment.setCode(object.getCode());
                String createdPermId = CreateExperimentExecutor.this.daoFactory.getPermIdDAO().createPermId();
                experiment.setPermId(createdPermId);
                experiment.setRegistrator(person);
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, person, timeStamp);
                experiments.add(experiment);
            }

            @Override
            public IProgress createProgress(ExperimentCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return experiments;
    }

    @Override
    protected ExperimentPermId createPermId(IOperationContext context, ExperimentPE entity) {
        return new ExperimentPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, ExperimentCreation creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
            throw new UserFailureException("Code cannot be empty.");
        }
        ExperimentIdentifierFactory.assertValidCode(creation.getCode());
    }

    @Override
    protected void checkAccess(IOperationContext context) {
    }

    @Override
    protected void checkAccess(IOperationContext context, ExperimentPE entity) {
        this.authorizationExecutor.canCreate(context, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<ExperimentCreation, ExperimentPE> batch) {
        this.setExperimentProjectExecutor.set(context, batch);
        this.setExperimentTypeExecutor.set(context, batch);
        this.updateEntityPropertyExecutor.update(context, batch);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<ExperimentCreation, ExperimentPE> batch) {
        HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>> attachmentMap = new HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>>();
        HashMap<IEntityWithMetaprojects, Collection<? extends ITagId>> tagMap = new HashMap<IEntityWithMetaprojects, Collection<? extends ITagId>>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            ExperimentCreation creation = (ExperimentCreation)entry.getKey();
            ExperimentPE entity = (ExperimentPE)entry.getValue();
            attachmentMap.put(entity, creation.getAttachments());
            tagMap.put(entity, creation.getTagIds());
        }
        this.createAttachmentExecutor.create(context, attachmentMap);
        this.addTagToEntityExecutor.add(context, tagMap);
    }

    @Override
    protected List<ExperimentPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getExperimentDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<ExperimentPE> entities, boolean clearCache) {
        this.daoFactory.getExperimentDAO().createOrUpdateExperiments(entities, context.getSession().tryGetPerson(), clearCache);
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, EntityKind.EXPERIMENT.getLabel(), EntityKind.EXPERIMENT);
    }

    @Override
    protected IObjectId getId(ExperimentPE entity) {
        return new ExperimentIdentifier(entity.getIdentifier());
    }
}

