/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.DeletionTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.delete.ExperimentDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IDeleteExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class DeleteExperimentExecutor
extends AbstractDeleteEntityExecutor<IDeletionId, IExperimentId, ExperimentPE, ExperimentDeletionOptions>
implements IDeleteExperimentExecutor {
    @Autowired
    private IExperimentAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;

    @Override
    protected Map<IExperimentId, ExperimentPE> map(IOperationContext context, List<? extends IExperimentId> entityIds, ExperimentDeletionOptions deletionOptions) {
        return this.mapExperimentByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, IExperimentId entityId, ExperimentPE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, ExperimentPE entity) {
        Session session = context.getSession();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)entity.getProject(), session, timeStamp);
    }

    @Override
    protected IDeletionId delete(IOperationContext context, Collection<ExperimentPE> entities, ExperimentDeletionOptions deletionOptions) {
        try {
            ITrashBO trashBO = this.businessObjectFactory.createTrashBO(context.getSession());
            trashBO.createDeletion(deletionOptions.getReason());
            trashBO.trashExperiments(this.asTechIds(entities));
            DeletionPE deletion = trashBO.getDeletion();
            return new DeletionTechId(deletion.getId());
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "deletion", null);
            return null;
        }
    }
}

