/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.AbstractMapObjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.IListObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.experiment.ListExperimentByIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.experiment.ListExperimentByPermId;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapExperimentByIdExecutor
extends AbstractMapObjectByIdExecutor<IExperimentId, ExperimentPE>
implements IMapExperimentByIdExecutor {
    private IProjectDAO projectDAO;
    private IExperimentDAO experimentDAO;
    @Autowired
    private IExperimentAuthorizationExecutor authorizationExecutor;

    private MapExperimentByIdExecutor() {
    }

    public MapExperimentByIdExecutor(IProjectDAO projectDAO, IExperimentDAO experimentDAO, IExperimentAuthorizationExecutor authorizationExecutor) {
        this.projectDAO = projectDAO;
        this.experimentDAO = experimentDAO;
        this.authorizationExecutor = authorizationExecutor;
    }

    @Override
    protected void checkAccess(IOperationContext context) {
        this.authorizationExecutor.canGet(context);
    }

    @Override
    protected void addListers(IOperationContext context, List<IListObjectById<? extends IExperimentId, ExperimentPE>> listers) {
        listers.add(new ListExperimentByPermId(this.experimentDAO));
        listers.add(new ListExperimentByIdentifier(this.projectDAO, this.experimentDAO));
    }

    @Autowired
    private void setDAOFactory(IDAOFactory daoFactory) {
        this.projectDAO = daoFactory.getProjectDAO();
        this.experimentDAO = daoFactory.getExperimentDAO();
    }
}

