/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.update.ExperimentUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.IEventExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IExperimentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IUpdateExperimentAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IUpdateExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IUpdateExperimentProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IUpdateExperimentPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagForEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingEvent;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingFlags;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateExperimentExecutor
extends AbstractUpdateEntityExecutor<ExperimentUpdate, ExperimentPE, IExperimentId, ExperimentPermId>
implements IUpdateExperimentExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IExperimentAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;
    @Autowired
    private IUpdateExperimentProjectExecutor updateExperimentProjectExecutor;
    @Autowired
    private IUpdateExperimentPropertyExecutor updateExperimentPropertyExecutor;
    @Autowired
    private IUpdateTagForEntityExecutor updateTagForEntityExecutor;
    @Autowired
    private IUpdateExperimentAttachmentExecutor updateExperimentAttachmentExecutor;
    @Autowired
    private IEventExecutor eventExecutor;

    @Override
    protected IExperimentId getId(ExperimentUpdate update) {
        return update.getExperimentId();
    }

    @Override
    protected ExperimentPermId getPermId(ExperimentPE entity) {
        return new ExperimentPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, ExperimentUpdate update) {
        if (update.getExperimentId() == null) {
            throw new UserFailureException("Experiment id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IExperimentId id, ExperimentPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<ExperimentUpdate, ExperimentPE> batch) {
        this.updateExperimentProjectExecutor.update(context, batch);
        this.updateExperimentPropertyExecutor.update(context, batch);
        this.updateTags(context, batch);
        this.updateAttachments(context, batch);
        PersonPE person = context.getSession().tryGetPerson();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        ArrayList<FreezingEvent> freezingEvents = new ArrayList<FreezingEvent>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            ExperimentUpdate update = (ExperimentUpdate)entry.getKey();
            ExperimentPE experiment = (ExperimentPE)entry.getValue();
            FreezingFlags freezingFlags = new FreezingFlags();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, person, timeStamp);
            if (update.shouldBeFrozen()) {
                this.authorizationExecutor.canFreeze(context, experiment);
                experiment.setFrozen(true);
                freezingFlags.freeze();
            }
            if (update.shouldBeFrozenForDataSets()) {
                this.authorizationExecutor.canFreeze(context, experiment);
                experiment.setFrozenForDataSet(true);
                freezingFlags.freezeForDataSets();
            }
            if (update.shouldBeFrozenForSamples()) {
                this.authorizationExecutor.canFreeze(context, experiment);
                experiment.setFrozenForSample(true);
                freezingFlags.freezeForSamples();
            }
            if (freezingFlags.noFlags()) continue;
            freezingEvents.add(new FreezingEvent(experiment.getIdentifier(), EventPE.EntityType.EXPERIMENT, freezingFlags));
        }
        if (!freezingEvents.isEmpty()) {
            this.eventExecutor.persist(context, freezingEvents);
        }
    }

    private void updateTags(final IOperationContext context, MapBatch<ExperimentUpdate, ExperimentPE> batch) {
        new MapBatchProcessor<ExperimentUpdate, ExperimentPE>(context, batch){

            @Override
            public void process(ExperimentUpdate update, ExperimentPE entity) {
                if (update.getTagIds() != null && update.getTagIds().hasActions()) {
                    UpdateExperimentExecutor.this.updateTagForEntityExecutor.update(context, entity, (IdListUpdateValue<ITagId>)update.getTagIds());
                }
            }

            @Override
            public IProgress createProgress(ExperimentUpdate update, ExperimentPE entity, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)update, entity, "experiment-tag", objectIndex, totalObjectCount);
            }
        };
    }

    private void updateAttachments(final IOperationContext context, MapBatch<ExperimentUpdate, ExperimentPE> batch) {
        new MapBatchProcessor<ExperimentUpdate, ExperimentPE>(context, batch){

            @Override
            public void process(ExperimentUpdate update, ExperimentPE entity) {
                if (update.getAttachments() != null && update.getAttachments().hasActions()) {
                    UpdateExperimentExecutor.this.updateExperimentAttachmentExecutor.update(context, entity, update.getAttachments());
                }
            }

            @Override
            public IProgress createProgress(ExperimentUpdate update, ExperimentPE entity, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)update, entity, "experiment-attachment", objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<ExperimentUpdate, ExperimentPE> batch) {
    }

    @Override
    protected Map<IExperimentId, ExperimentPE> map(IOperationContext context, Collection<IExperimentId> ids) {
        return this.mapExperimentByIdExecutor.map(context, ids);
    }

    @Override
    protected List<ExperimentPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getExperimentDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<ExperimentPE> entities, boolean clearCache) {
        this.daoFactory.getExperimentDAO().createOrUpdateExperiments(entities, context.getSession().tryGetPerson(), clearCache);
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, EntityKind.EXPERIMENT.getLabel(), EntityKind.EXPERIMENT);
    }
}

