/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IVerifyExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IVerifyEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifyExperimentExecutor
implements IVerifyExperimentExecutor {
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;
    @Autowired
    private IVerifyEntityPropertyExecutor verifyEntityPropertyExecutor;

    private VerifyExperimentExecutor() {
    }

    public VerifyExperimentExecutor(IVerifyEntityPropertyExecutor verifyEntityPropertyExecutor) {
        this.verifyEntityPropertyExecutor = verifyEntityPropertyExecutor;
    }

    @Override
    public void verify(IOperationContext context, CollectionBatch<? extends IExperimentId> experimentIds) {
        if (experimentIds != null && !experimentIds.isEmpty()) {
            Map map = this.mapExperimentByIdExecutor.map(context, (Collection)experimentIds.getObjects());
            CollectionBatch experiments = new CollectionBatch(experimentIds.getBatchIndex(), experimentIds.getFromObjectIndex(), experimentIds.getToObjectIndex(), map.values(), experimentIds.getTotalObjectCount());
            this.verifyEntityPropertyExecutor.verify(context, experiments);
        }
    }
}

