/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.AddressSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.ExternalDmsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.ExternalDmsTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.search.LabelSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.AddressMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.ExternalDmsTypeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.IExternalDmsAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.ISearchExternalDmsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.LabelMatcher;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchExternalDmsExecutor
extends AbstractSearchObjectManuallyExecutor<ExternalDmsSearchCriteria, ExternalDataManagementSystemPE>
implements ISearchExternalDmsExecutor {
    @Autowired
    private IExternalDmsAuthorizationExecutor authorizationExecutor;

    @Override
    public List<ExternalDataManagementSystemPE> search(IOperationContext context, ExternalDmsSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<ExternalDataManagementSystemPE> listAll() {
        return this.daoFactory.getExternalDataManagementSystemDAO().listExternalDataManagementSystems();
    }

    @Override
    protected Matcher<ExternalDataManagementSystemPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<ExternalDataManagementSystemPE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<ExternalDataManagementSystemPE>();
        }
        if (criteria instanceof LabelSearchCriteria) {
            return new LabelMatcher();
        }
        if (criteria instanceof AddressSearchCriteria) {
            return new AddressMatcher();
        }
        if (criteria instanceof ExternalDmsTypeSearchCriteria) {
            return new ExternalDmsTypeMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }
}

