/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.ExternalDmsPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.id.IExternalDmsId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.update.ExternalDmsUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.IExternalDmsAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.IMapExternalDmsByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.externaldms.IUpdateExternalDmsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystemType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataManagementSystemPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateExternalDmsExecutor
extends AbstractUpdateEntityExecutor<ExternalDmsUpdate, ExternalDataManagementSystemPE, IExternalDmsId, ExternalDmsPermId>
implements IUpdateExternalDmsExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapExternalDmsByIdExecutor mapExternalDmsByIdExecutor;
    @Autowired
    private IExternalDmsAuthorizationExecutor authorizationExecutor;

    @Override
    protected IExternalDmsId getId(ExternalDmsUpdate update) {
        return update.getExternalDmsId();
    }

    @Override
    protected ExternalDmsPermId getPermId(ExternalDataManagementSystemPE entity) {
        return new ExternalDmsPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, ExternalDmsUpdate update) {
        if (update.getAddress().isModified() && (update.getAddress().getValue() == null || ((String)update.getAddress().getValue()).isEmpty())) {
            throw new UserFailureException("Address is required");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, IExternalDmsId id, ExternalDataManagementSystemPE entity) {
        this.authorizationExecutor.canUpdate(context);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<ExternalDmsUpdate, ExternalDataManagementSystemPE> batch) {
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            String pattern;
            ExternalDmsUpdate update = (ExternalDmsUpdate)entry.getKey();
            ExternalDataManagementSystemPE edms = (ExternalDataManagementSystemPE)entry.getValue();
            if (update.getLabel().isModified()) {
                edms.setLabel((String)update.getLabel().getValue());
            }
            if (!update.getAddress().isModified()) continue;
            String address = (String)update.getAddress().getValue();
            if (ExternalDataManagementSystemType.FILE_SYSTEM.equals((Object)edms.getAddressType()) && !address.matches(pattern = "^[^:]+:[^:]+$")) {
                throw new UserFailureException("Invalid address: " + address);
            }
            edms.setAddress(address);
        }
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<ExternalDmsUpdate, ExternalDataManagementSystemPE> batch) {
    }

    @Override
    protected Map<IExternalDmsId, ExternalDataManagementSystemPE> map(IOperationContext context, Collection<IExternalDmsId> ids) {
        return this.mapExternalDmsByIdExecutor.map(context, ids);
    }

    @Override
    protected List<ExternalDataManagementSystemPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getExternalDataManagementSystemDAO().listExternalDataManagementSystems(ids);
    }

    @Override
    protected void save(IOperationContext context, List<ExternalDataManagementSystemPE> entities, boolean clearCache) {
        for (ExternalDataManagementSystemPE entity : entities) {
            this.daoFactory.getExternalDataManagementSystemDAO().createOrUpdateExternalDataManagementSystem(entity);
        }
        this.daoFactory.getSessionFactory().getCurrentSession().flush();
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "externaldms", null);
    }
}

