/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.globalsearch;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsExactlyValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKindCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchTextCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchWildCardsCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.globalsearch.IGlobalSearchExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.HibernateSearchDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalSearchExecutor
implements IGlobalSearchExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public List<MatchingEntity> search(IOperationContext context, GlobalSearchCriteria criteria) {
        String userName = context.getSession().getUserName();
        String queryText = this.getQueryText(criteria);
        Collection<SearchableEntity> entityKinds = this.getEntityKinds(criteria);
        boolean wildCards = this.getWildCards(criteria);
        ArrayList<MatchingEntity> list = new ArrayList<MatchingEntity>();
        if (queryText != null && queryText.trim().length() > 0) {
            for (SearchableEntity entityKind : entityKinds) {
                HibernateSearchDataProvider dataProvider = new HibernateSearchDataProvider(this.daoFactory);
                List<MatchingEntity> entities = this.daoFactory.getHibernateSearchDAO().searchEntitiesByTerm(userName, entityKind, queryText, dataProvider, wildCards, list.size(), Integer.MAX_VALUE);
                list.addAll(entities);
            }
        }
        return list;
    }

    private boolean getWildCards(GlobalSearchCriteria criteria) {
        for (ISearchCriteria subCriteria : criteria.getCriteria()) {
            if (!(subCriteria instanceof GlobalSearchWildCardsCriteria)) continue;
            return true;
        }
        return false;
    }

    private String getQueryText(GlobalSearchCriteria criteria) {
        ArrayList<String> texts = new ArrayList<String>();
        for (ISearchCriteria subCriteria : criteria.getCriteria()) {
            if (!(subCriteria instanceof GlobalSearchTextCriteria)) continue;
            GlobalSearchTextCriteria textSubCriteria = (GlobalSearchTextCriteria)subCriteria;
            if (textSubCriteria.getFieldValue() instanceof StringContainsValue) {
                texts.add((String)((AbstractStringValue)textSubCriteria.getFieldValue()).getValue());
                continue;
            }
            if (!(textSubCriteria.getFieldValue() instanceof StringContainsExactlyValue)) continue;
            texts.add("\"" + (String)((AbstractStringValue)textSubCriteria.getFieldValue()).getValue() + "\"");
        }
        return StringUtils.join(texts, (String)" ");
    }

    private Collection<SearchableEntity> getEntityKinds(GlobalSearchCriteria criteria) {
        GlobalSearchObjectKindCriteria lastObjectKindSubCriteria = null;
        for (ISearchCriteria subCriteria : criteria.getCriteria()) {
            if (!(subCriteria instanceof GlobalSearchObjectKindCriteria)) continue;
            lastObjectKindSubCriteria = (GlobalSearchObjectKindCriteria)subCriteria;
        }
        if (lastObjectKindSubCriteria == null || lastObjectKindSubCriteria.getObjectKinds() == null || lastObjectKindSubCriteria.getObjectKinds().isEmpty()) {
            return Arrays.asList(SearchableEntity.values());
        }
        List objectKinds = lastObjectKindSubCriteria.getObjectKinds();
        HashSet<SearchableEntity> entityKinds = new HashSet<SearchableEntity>();
        for (GlobalSearchObjectKind objectKind : objectKinds) {
            SearchableEntity entityKind = null;
            switch (objectKind) {
                case EXPERIMENT: {
                    entityKind = SearchableEntity.EXPERIMENT;
                    break;
                }
                case SAMPLE: {
                    entityKind = SearchableEntity.SAMPLE;
                    break;
                }
                case DATA_SET: {
                    entityKind = SearchableEntity.DATA_SET;
                    break;
                }
                case MATERIAL: {
                    entityKind = SearchableEntity.MATERIAL;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported object kind " + objectKind);
                }
            }
            entityKinds.add(entityKind);
        }
        return entityKinds;
    }
}

