/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.globalsearch;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchObjectsOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchObjectsOperationResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.GlobalSearchObject;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKindCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.SearchGloballyOperation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.SearchGloballyOperationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.ISearchObjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SearchObjectsOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.globalsearch.IGlobalAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.globalsearch.IGlobalSearchExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.globalsearch.ISearchGloballyOperationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.SortAndPage;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.auth.AuthorisationInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.GlobalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.search.planner.ILocalSearchManager;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.ITranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.globalsearch.IGlobalSearchObjectTranslator;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchGloballyOperationExecutor
extends SearchObjectsOperationExecutor<GlobalSearchObject, MatchingEntity, GlobalSearchCriteria, GlobalSearchObjectFetchOptions>
implements ISearchGloballyOperationExecutor {
    private static final Logger OPERATION_LOG = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SearchGloballyOperationExecutor.class);
    @Autowired
    private IGlobalSearchExecutor searchExecutor;
    @Autowired
    private IGlobalSearchObjectTranslator translator;
    @Autowired
    private IGlobalAuthorizationExecutor authorizationExecutor;
    @Autowired
    private GlobalSearchManager globalSearchManager;
    @Autowired
    private AuthorizationConfig authorizationConfig;

    @Override
    protected SearchObjectsOperationResult<GlobalSearchObject> doExecute(IOperationContext context, SearchObjectsOperation<GlobalSearchCriteria, GlobalSearchObjectFetchOptions> operation) {
        this.authorizationExecutor.canSearch(context);
        GlobalSearchCriteria criteria = (GlobalSearchCriteria)operation.getCriteria();
        GlobalSearchObjectFetchOptions fetchOptions = (GlobalSearchObjectFetchOptions)operation.getFetchOptions();
        if (criteria == null) {
            throw new IllegalArgumentException("Criteria cannot be null.");
        }
        if (fetchOptions == null) {
            throw new IllegalArgumentException("Fetch options cannot be null.");
        }
        PersonPE personPE = context.getSession().tryGetPerson();
        AuthorisationInformation authorisationInformation = AuthorisationInformation.getInstance(personPE, this.authorizationConfig);
        Long userId = context.getSession().tryGetPerson().getId();
        TranslationContext translationContext = new TranslationContext(context.getSession());
        Set<GlobalSearchObjectKind> objectKinds = SearchGloballyOperationExecutor.getObjectKinds(criteria);
        Collection<Map<String, Object>> shortRecords = this.globalSearchManager.searchForIDs(userId, authorisationInformation, criteria, null, objectKinds, fetchOptions, false);
        List<Map<String, Object>> detailsRecords = shortRecords.isEmpty() ? Collections.emptyList() : this.globalSearchManager.searchForDetails(shortRecords, userId, authorisationInformation, criteria, null, objectKinds, fetchOptions);
        Collection<MatchingEntity> pagedMatchingEntities = this.globalSearchManager.map(detailsRecords, fetchOptions.hasMatch());
        Map pagedResultV3DTOs = this.doTranslate(translationContext, pagedMatchingEntities, fetchOptions);
        if (pagedMatchingEntities.size() != pagedResultV3DTOs.size()) {
            throw new RuntimeException(String.format("Number of results after translation has changed. Total count value will be incorrect. [pagedResultPEs.size()=%d, pagedResultV3DTOs.size()=%d]", pagedMatchingEntities.size(), pagedResultV3DTOs.size()));
        }
        List objectResults = pagedMatchingEntities.stream().map(pagedResultV3DTOs::get).filter(Objects::nonNull).collect(Collectors.toList());
        new SortAndPage().nest(objectResults, (ISearchCriteria)criteria, (FetchOptions)fetchOptions);
        Collection<Map<String, Object>> totalCountCollection = shortRecords.isEmpty() ? this.globalSearchManager.searchForIDs(userId, authorisationInformation, criteria, null, objectKinds, fetchOptions, true) : shortRecords;
        int totalCount = (int)((Long)totalCountCollection.iterator().next().get("total_count")).longValue();
        return this.getOperationResult((SearchResult<GlobalSearchObject>)new SearchResult(objectResults, totalCount));
    }

    private static Set<GlobalSearchObjectKind> getObjectKinds(GlobalSearchCriteria globalSearchCriteria) {
        EnumSet<GlobalSearchObjectKind> objectKinds;
        Stream<GlobalSearchObjectKindCriteria> objectKindCriteriaStream = globalSearchCriteria.getCriteria().stream().filter(criterion -> criterion instanceof GlobalSearchObjectKindCriteria).map(criterion -> (GlobalSearchObjectKindCriteria)criterion);
        switch (globalSearchCriteria.getOperator()) {
            case OR: {
                objectKinds = EnumSet.noneOf(GlobalSearchObjectKind.class);
                objectKindCriteriaStream.forEach(objectKindCriterion -> objectKinds.addAll(objectKindCriterion.getObjectKinds()));
                break;
            }
            case AND: {
                objectKinds = EnumSet.allOf(GlobalSearchObjectKind.class);
                objectKindCriteriaStream.forEach(objectKindCriterion -> objectKinds.retainAll(objectKindCriterion.getObjectKinds()));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return objectKinds.isEmpty() ? EnumSet.allOf(GlobalSearchObjectKind.class) : objectKinds;
    }

    @Override
    protected Class<? extends SearchObjectsOperation<GlobalSearchCriteria, GlobalSearchObjectFetchOptions>> getOperationClass() {
        return SearchGloballyOperation.class;
    }

    @Override
    protected ISearchObjectExecutor<GlobalSearchCriteria, MatchingEntity> getExecutor() {
        return this.searchExecutor;
    }

    @Override
    protected ITranslator<MatchingEntity, GlobalSearchObject, GlobalSearchObjectFetchOptions> getTranslator() {
        return this.translator;
    }

    @Override
    protected ILocalSearchManager<GlobalSearchCriteria, GlobalSearchObject, MatchingEntity> getSearchManager() {
        throw new IllegalStateException("This method should not be executed. globalSearchManager should be used instead.");
    }

    @Override
    protected SearchObjectsOperationResult<GlobalSearchObject> getOperationResult(SearchResult<GlobalSearchObject> searchResult) {
        return new SearchGloballyOperationResult(searchResult);
    }
}

